use hahn;
pragma yt.ForceInferSchema;

$table_mirrors          = "//home/webmaster/prod/analytics/mirrors";
$table_root             = "//home/webmaster/prod/export/archive/webmaster-verified-hosts";
$table_site_problems    = "//home/webmaster/prod/analytics/checklist/site-problems";
$table_output           = "//home/webmaster/prod/analytics/mailings/hosts-verified";

$GetTurboDomain = ($host) -> {
    $CutWWWM = Re2::Capture("^(www\\.|m\\.)?(.+)$");

    return $CutWWWM(Url::GetHost($host))._2;
};

$GetMetrikaDomain = ($host) -> {
    return Url::CutWWW(Url::GetHost($host));
};

$table_input = (
    select Path from folder($table_root)
    where Type == "table"
    order by Path desc limit 1
);

insert into $table_output
    with truncate
select 
    Url::PunycodeToHostName(Url::CutWWW(Url::CutScheme(host_url))) as Domain,
    $GetTurboDomain(host_url) as TurboDomain,
    $GetMetrikaDomain(host_url) as MetrikaDomain,
    Url::GetOwner(host_url) as Owner,
    host_id as HostId,
    host_url as HostUrl,
    coalesce(MainHost, host_url) as MainMirror,
    cast(user_id as UInt64) as UserId,
    visible == "true" as Visible,
    SiteProblems
from concat($table_input) as h
left join $table_mirrors as m
    on h.host_url == m.Host
left join $table_site_problems as sp
    on h.host_url == sp.Host
order by UserId, HostId
