use hahn;

$activeMessageTypes = (SELECT message_type FROM `//home/webmaster/prod/analytics/mailings/active_message_types`);
$fixMessageType = ($m) -> { return String::ReplaceAll($m, "-", "_"); } ;
$weighted_avg = ($values, $delta) -> {
    return
        ListSum(ListMap(ListEnumerate($values), ($t) -> { return (20.0 - abs(cast($t.0 as Double) - $delta)) * $t.1;})) /
        ListSum(ListMap(ListEnumerate($values), ($t) -> { return (20.0 - abs(cast($t.0 as Double) - $delta));}))
};

INSERT INTO `//home/webmaster/prod/analytics/mailings/funnel` WITH TRUNCATE
SELECT day, message_type, sent, opened, visits, sent_list, opened_list, visits_list, start_day,
    MIN_OF(if (Math::IsNaN(sent), null, 100.0 * opened / sent), 100.0) as open_rate,
    MIN_OF(if (Math::IsNaN(opened), null, 100.0 * visits / opened), 100.0) as visit_rate
FROM
(
    SELECT day, message_type, sent_list, opened_list, visits_list, start_day,
        $weighted_avg(sent_list, DateTime::ToDays(day - start_day)) as sent,
        $weighted_avg(opened_list, DateTime::ToDays(day - start_day)) as opened,
        $weighted_avg(visits_list, DateTime::ToDays(day - start_day)) as visits
    FROM
    (
        SELECT
            day,
            message_type,
            aggregate_list(nvl(sent, 0)) over w as sent_list,
            aggregate_list(nvl(opened, 0)) over w as opened_list,
            aggregate_list(nvl(visits, 0)) over w as visits_list,
            first_value(day) over w as start_day
        FROM
        (
            SELECT
                day,
                message_type,
                sum(s.sent) as sent,
                sum(o.opened) as opened,
                sum(v.visits) as visits,
            FROM
                `//home/webmaster/prod/analytics/mailings/messages_sent_by_type` as s
            FULL JOIN
                `//home/webmaster/prod/analytics/mailings/zeropixel/aggregated` as o
                ON s.`date` == o.`date` and $fixMessageType(s.message_type) == $fixMessageType(o.message_type)
            FULL JOIN
                `//home/webmaster/prod/analytics/mailings/metrika_visits_by_type` as v
                ON v.`date` == s.`date` and $fixMessageType(v.message_type) == $fixMessageType(s.message_type)
            WHERE
                $fixMessageType(coalesce(s.message_type, o.message_type, v.message_type)) in $activeMessageTypes
            GROUP BY
                coalesce(s.`date`, o.`date`, v.`date`) as day,
                $fixMessageType(coalesce(s.message_type, o.message_type, v.message_type)) as message_type
        )
        WINDOW w AS (
            PARTITION BY message_type
            ORDER BY day
            ROWS BETWEEN 15 PRECEDING AND 15 FOLLOWING
        )
    )
)
ORDER BY day, message_type;
