use arnold;

$captureMessageType = Re2::Capture('messageType=([^ ]+)');
$captureTimestamp = Re2::Capture('timestamp=([^ ]+)');
$type = 'MESSAGES_SENT_LAST_UPDATE';
$dateFromTs = ($ts) -> {
    return DateTime::MakeDate(DateTime::Update(AddTimezone(DateTime::FromSeconds(cast($ts as Uint32)), "Europe/Moscow"), 'UTC' as Timezone))
};

$lastProcessed = (SELECT value FROM `//home/webmaster/prod/analytics/state` WHERE type = $type);
$newMaxDate = (SELECT max(TableName(Path)) FROM FOLDER(`home/webmaster/prod/analytics/logs/deploy/backend/webmaster3-worker`) WHERE Type == 'table');

EVALUATE IF $newMaxDate > $lastProcessed DO
BEGIN

    INSERT INTO `//home/webmaster/prod/analytics/mailings/messages_sent_by_type`
    SELECT `date`, message_type, count(*) as sent
    FROM range(`home/webmaster/prod/analytics/logs/deploy/backend/webmaster3-worker`, $lastProcessed || '1', $newMaxDate)
    WHERE message like '%Email tracking: %' and $captureMessageType(message)._1 is not null and $captureTimestamp(message)._1 is not null
    GROUP BY $dateFromTs(`timestamp`) as `date`, $captureMessageType(message)._1 as message_type
    ORDER BY `date`, message_type;

    INSERT INTO `//home/webmaster/prod/analytics/state` WITH truncate
    SELECT type, if(type == $type, $newMaxDate, value) as value
    FROM `//home/webmaster/prod/analytics/state`;

END DO;
