use hahn;

$table_hosts_verified       = "//home/webmaster/prod/analytics/mailings/hosts-verified";
$table_input_bindings       = "//home/webmaster/prod/analytics/metrika/bindings";
$table_input_has_metrika    = "//home/webmaster/prod/analytics/metrika/has_metrika";
$table_input_use_metrika    = "//home/webmaster/prod/analytics/metrika/use_metrika";
$table_input_crawl_settings = "//home/webmaster/prod/analytics/metrika/crawl-settings";
$table_output               = "//home/webmaster/prod/analytics/mailings/metrika";

$verified_domains = (
    select distinct MetrikaDomain
    from $table_hosts_verified
);

$metrika_domains = (
    select distinct MetrikaDomain
    from (
                    select MetrikaDomain from $table_input_bindings
        union all   select MetrikaDomain from $table_input_crawl_settings
        union all   select MetrikaDomain from $table_input_has_metrika
        union all   select MetrikaDomain from $table_input_use_metrika
    )
);

$data = (
    select 
        md.MetrikaDomain as MetrikaDomain,
        Yson::Serialize(
            Yson::From(
                AsStruct(
                    MetrikaBindings as Bindings,
                    cs.Counters as CrawlCounters,
                    AsStruct(
                        hm.ToShow as ToShow,
                        hm.HasMetrikaAggr as HasMetrikaAggr
                    ) as HasMetrika,
                    um.MetrikaDomain is not null as UseMetrika
                )
            )
        ) as MetrikaParams
    from $metrika_domains as md
    left join $table_input_bindings as b
        on md.MetrikaDomain == b.MetrikaDomain
    left join $table_input_has_metrika as hm
        on md.MetrikaDomain == hm.MetrikaDomain
    left join $table_input_crawl_settings as cs
        on md.MetrikaDomain == cs.MetrikaDomain
    left join $table_input_use_metrika as um
        on md.MetrikaDomain == um.MetrikaDomain
);

insert into $table_output
    with truncate
select 
    MetrikaDomain,
    MetrikaParams
from $data
where MetrikaDomain in $verified_domains
order by MetrikaDomain;
