#!/bin/bash

PROD_STATE=$(yt --proxy arnold get //home/jupiter/@jupiter_meta/production_current_state --format=dsv)
SYNC_STATE=$(yt --proxy hahn get //home/webmaster/prod/analytics/mirrors/@production_current_state --format=dsv)

if [ "$SYNC_STATE" = "$PROD_STATE" ]; then
    exit 0
fi

transfer-manager add-task --sync --src-cluster arnold --src-table "//home/jupiter/export/$PROD_STATE/mirrors/mirrors" \
    --dst-cluster hahn --dst-table //home/webmaster/prod/analytics/mirrors

echo "\"$PROD_STATE\"" | yt --proxy hahn set //home/webmaster/prod/analytics/mirrors/@production_current_state --format=json
