use hahn;

$table_input    = "//home/webmaster/prod/export/turbo/turbo-hosts";
$table_output   = "//home/webmaster/prod/analytics/mailings/turbo-settings";

$GetTurboDomain = ($host) -> {
    $CutWWWM = Re2::Capture("^(www\\.|m\\.)?(.+)$");

    return $CutWWWM(Url::GetHost($host))._2;
};

$IsActiveYML = ($feed) -> {
    return Yson::ConvertToString($feed.type) == "YML"
        and Yson::ConvertToString($feed.state) == "ACTIVE";
};

$IsActiveRSS = ($feed) -> {
    return Yson::ConvertToString($feed.type) == "RSS"
        and Yson::ConvertToString($feed.state) == "ACTIVE";
};

$IsTurboShop = ($feeds) -> {
    return ListLength(
        ListFilter(
            Yson::ConvertToList($feeds),
            $IsActiveYML
        )
    ) > 0
};

$IsTurboContent = ($feeds) -> {
    return ListLength(
        ListFilter(
            Yson::ConvertToList($feeds),
            $IsActiveRSS
        )
    ) > 0
};

insert into $table_output
    with truncate
select
    Host,
    $GetTurboDomain(Host)                                   as TurboDomain,
    Yson::ParseJson(Yson::ConvertToString(Advertising))     as TurboAdvertising,
    Yson::ParseJson(Yson::ConvertToString(Analytics))       as TurboAnalytics,
    Authorization                                           as TurboAuthorization,
    AutoMorda                                               as TurboAutoMorda,
    AutoRelated                                             as TurboAutoRelated,
    CategoryInfo                                            as TurboCategoryInfo,
    Comments                                                as TurboComments,
    Css                                                     as TurboCss,
    Description                                             as TurboDescription,
    Desktop                                                 as TurboDesktop,
    Ecommerce                                               as TurboEcommerce,
    Yson::ParseJson(Experiment)                             as TurboExperiment,
    Yson::ParseJson(Yson::ConvertToString(Feedback))        as TurboFeedback,
    Yson::ParseJson(Yson::ConvertToString(Feeds))           as TurboFeeds,
    Yson::ParseJson(Yson::ConvertToString(HeaderParams))    as TurboHeaderParams,
    HeaderType                                              as TurboHeaderType,
    Yson::ParseJson(Yson::ConvertToString(Logo))            as TurboLogo,
    LogoGroupId                                             as TurboLogoGroupId,
    LogoId                                                  as TurboLogoId,
    LogoSquare                                              as TurboLogoSquare,
    Yson::ParseJson(Yson::ConvertToString(Menu))            as TurboMenu,
    ProductInfo                                             as TurboProductInfo,
    Search                                                  as TurboSearch,
    Theme                                                   as TurboTheme,
    Title                                                   as TurboTitle,
    TurboApp,
    TurboPlus,
    $IsTurboShop(Yson::ParseJson(Yson::ConvertToString(Feeds))) as IsTurboShop,
    $IsTurboContent(Yson::ParseJson(Yson::ConvertToString(Feeds))) as IsTurboContent,
from $table_input
order by TurboDomain
