use hahn;
pragma yt.ForceInferSchema = '500';

$output_table = "//home/webmaster/prod/analytics/mailings/users-emails";

PRAGMA File('libcrypta_identifier_udf.so', 'yt://hahn/home/crypta/public/udfs/stable/libcrypta_identifier_udf.so');
PRAGMA Udf('libcrypta_identifier_udf.so');

$eu_emails = (
    select Identifiers::Email(email).Normalize as email from `//home/crypta/public/ids_storage/email/emails_eu`
);

insert into $output_table
    with truncate
select
    UserId,
    Email,
    IsEuropeanUser,
    max(language == 'RU') as LanguageRU,
    max(language == 'EN') as LanguageEN,
    max(notification_type == "DIGEST")                                      as DIGEST,
    max(notification_type == "DIGEST_LITE")                                 as DIGEST_LITE,
    max(notification_type == "GLOBAL_NOTIFICATION")                         as GLOBAL_NOTIFICATION,
    max(notification_type == "IMPORTANT_URLS_AUTO_ADD")                     as IMPORTANT_URLS_AUTO_ADD,
    max(notification_type == "MAIN_MIRROR_UPDATE")                          as MAIN_MIRROR_UPDATE,
    max(notification_type == "METRIKA_COUNTER_CRAWL")                       as METRIKA_COUNTER_CRAWL,
    max(notification_type == "METRIKA_COUNTERS")                            as METRIKA_COUNTERS,
    max(notification_type == "NEW_DOMAINS_NOTIFICATION")                    as NEW_DOMAINS_NOTIFICATION,
    max(notification_type == "NEW_REVIEW_AVAILABLE")                        as NEW_REVIEW_AVAILABLE,
    max(notification_type == "PERSONAL_SUPPORT")                            as PERSONAL_SUPPORT,
    max(notification_type == "POST_WELCOME_NOTIFICATION")                   as POST_WELCOME_NOTIFICATION,
    max(notification_type == "RECOMMENDED_QUERIES")                         as RECOMMENDED_QUERIES,
    max(notification_type == "ROBOTS_TXT_CHANGE")                           as ROBOTS_TXT_CHANGE,
    max(notification_type == "SEARCH_BASE_UPDATE")                          as SEARCH_BASE_UPDATE,
    max(notification_type == "SERP_LINKS_UPDATE")                           as SERP_LINKS_UPDATE,
    max(notification_type == "SITE_ACCESS")                                 as SITE_ACCESS,
    max(notification_type == "SITE_DISPLAY_NAME")                           as SITE_DISPLAY_NAME,
    max(notification_type == "SITE_PROBLEM_CRITICAL")                       as SITE_PROBLEM_CRITICAL,
    max(notification_type == "SITE_PROBLEM_FATAL")                          as SITE_PROBLEM_FATAL,
    max(notification_type == "SITE_PROBLEM_POSSIBLE")                       as SITE_PROBLEM_POSSIBLE,
    max(notification_type == "SITE_PROBLEM_RECOMMENDATION")                 as SITE_PROBLEM_RECOMMENDATION,
    max(notification_type == "SITE_REGIONS")                                as SITE_REGIONS,
    max(notification_type == "TRENDS")                                      as TRENDS,
    max(notification_type == "TURBO_ADV_SETTINGS_CHANGE")                   as TURBO_ADV_SETTINGS_CHANGE,
    max(notification_type == "TURBO_BAN")                                   as TURBO_BAN,
    max(notification_type == "TURBO_ERROR")                                 as TURBO_ERROR,
    max(notification_type == "TURBO_NEW")                                   as TURBO_NEW,
    max(notification_type == "TURBO_WARNING")                               as TURBO_WARNING,
    max(notification_type == "UNVERIFIED_HOST_REMOVAL_AFTER_THREE_WEEK")    as UNVERIFIED_HOST_REMOVAL_AFTER_THREE_WEEK,
    max(notification_type == "UNVERIFIED_HOST_REMOVAL_AFTER_WEEK")          as UNVERIFIED_HOST_REMOVAL_AFTER_WEEK,
    max(notification_type == "URL_DESCRIPTION_CHANGE")                      as URL_DESCRIPTION_CHANGE,
    max(notification_type == "URL_INDEXING_LAST_ACCESS_CHANGE")             as URL_INDEXING_LAST_ACCESS_CHANGE,
    max(notification_type == "URL_INDEXING_STATUS_CHANGE")                  as URL_INDEXING_STATUS_CHANGE,
    max(notification_type == "URL_REL_CANONICAL_TARGET_CHANGE")             as URL_REL_CANONICAL_TARGET_CHANGE,
    max(notification_type == "URL_SEARCH_LAST_ACCESS_CHANGE")               as URL_SEARCH_LAST_ACCESS_CHANGE,
    max(notification_type == "URL_SEARCH_STATUS_CHANGE")                    as URL_SEARCH_STATUS_CHANGE,
    max(notification_type == "URL_TITLE_CHANGE")                            as URL_TITLE_CHANGE,
from `//home/webmaster/prod/user/user-notification-settings/user-notification-channel-settings` as s
left join $eu_emails as eu using (email)
where channel_email == true and s.email is not null
group by
    s.user_id as UserId,
    s.email as Email,
    eu.email is not null as IsEuropeanUser
order by
    UserId,
    Email
;
