USE hahn;
$fixMessageType=Re2::Replace("([A-Z_\-]*).*");

$lastProcessed = (select value from `//home/webmaster/prod/analytics/state` where type = 'ZERO_PIXEL_LAST_UPDATE');
$newMaxDate = (select max(TableName(Path)) from FOLDER(`logs/webmaster-front-balancer-log/1d`) where Type == 'table');
$dateFromTs = ($ts) -> {
    return DateTime::MakeDate(DateTime::Update(AddTimezone(DateTime::FromSeconds(cast($ts as Uint32)), "Europe/Moscow"), 'UTC' as Timezone))
};

EVALUATE IF $newMaxDate > $lastProcessed DO
BEGIN

    $raw = (
        select `timestamp` as `timestamp`,
            $fixMessageType(Url::Decode(Url::GetCGIParam(request, 'messageType')),'\\1') as message_type,
            Url::Decode(Url::GetCGIParam(request, 'hostId')) as host_id,
            Url::GetCGIParam(request, 'userId') as user_id,
            Url::GetCGIParam(request, 'timestamp') as message_timestamp
        from
            RANGE(`logs/webmaster-front-balancer-log/1d`, $lastProcessed || '1', $newMaxDate)
        where
            request like '/tracker?%' and
            nvl($fixMessageType(Url::Decode(Url::GetCGIParam(request, 'messageType')),'\\1'), '') <> ''
    );
    insert into `//home/webmaster/prod/analytics/mailings/zeropixel/aggregated`
    select `date`, message_type, count(*) as opened
    from $raw
    group by $dateFromTs(`timestamp`) as `date`, message_type
    order by `date`, message_type;

    insert into `//home/webmaster/prod/analytics/mailings/zeropixel/raw`
    select `timestamp`,
        message_type,
        host_id,
        cast(user_id as Uint64) as user_id,
        cast(message_timestamp as Uint32) as message_timestamp
    from $raw
    order by `timestamp`;

    insert into `//home/webmaster/prod/analytics/state` with truncate
    select type, if(type == 'ZERO_PIXEL_LAST_UPDATE', $newMaxDate, value) as value
    from `//home/webmaster/prod/analytics/state`;

END DO;
