use hahn;

insert into `//home/webmaster/prod/analytics/metrika/bindings`
    with truncate
select 
    domain as MetrikaDomain,
    Yson::Serialize(
        Yson::From(
            aggregate_list(
                AsStruct(
                    counter_id as CounterId,
                    status as Status,
                    cast(
                        DateTime::MakeDatetime(
                            DateTime::ParseIso8601(update_time)
                        ) as String
                    ) as UpdateTime,
                    webmaster_uid as WebmasterUID,
                    metrika_uid as MetrikaUID
                )
            )
        )
    ) as MetrikaBindings,
from `//home/webmaster/prod/export/metrika/domains_counter_links`
group by domain
order by MetrikaDomain
