use hahn;

-- На основе таблиц от Метрики hahn://home/metrika/code/has_metrika.XXXX-XX-XX

$src_root = "//home/metrika/code";

$src_latest = (
    select TableName(Path, "yt") as Period
    from folder($src_root)
    where Type == "table"
        and TableName(Path, "yt") rlike '^has_metrika.\\d{4}-\\d{2}-\\d{2}$'
    order by Period desc
    limit 1
);

$src_table = $src_root || "/" || $src_latest;

insert into `//home/webmaster/prod/analytics/metrika/has_metrika`
    with truncate
select 
    String::ToLower(Url::HostNameToPunycode(domain)) as MetrikaDomain,
    to_show > 0 as ToShow,
    has_metrika_aggr as HasMetrikaAggr
from $src_table
order by MetrikaDomain
