use arnold;

-- pragma yt.AutoMerge="disabled";
-- pragma yt.Pool="robot-webmaster";
pragma yt.InferSchema='1';

$porn_hosts = 
select Host 
from `//home/webmaster/prod/searchqueries/catalogia2/one-week/unique-our-new-statistics`
where IsPornoHost or PornoQueries * 10 >= 7 * TotalQueries  
union all 
select Host
from `//home/antispam/nasty/linear/porno_database`
;

$table =
select Host, Rival, Rival in $porn_hosts as IsRivalPorn, TableName(TablePath()) as `Date`
from range(`//home/webmaster/prod/searchqueries/niche/import/rival_queries_report`)
where (not (Host in $porn_hosts)) and (Rival in $porn_hosts)
;

$tmp = 
select Host, count_if(IsRivalPorn == true) as Measure, `Date`
from $table
group by `Date`, Host
;

insert into `//home/webmaster/prod/analytics/niche/porn_stupids_distribution` WITH TRUNCATE 
select `Date`,
    PERCENTILE(Measure, 0.10) as `p010`,
    PERCENTILE(Measure, 0.20) as `p020`,
    PERCENTILE(Measure, 0.30) as `p030`,
    PERCENTILE(Measure, 0.40) as `p040`,
    PERCENTILE(Measure, 0.50) as `p050`,
    PERCENTILE(Measure, 0.60) as `p060`,
    PERCENTILE(Measure, 0.70) as `p070`,
    PERCENTILE(Measure, 0.80) as `p080`,
    PERCENTILE(Measure, 0.90) as `p090`,
    PERCENTILE(Measure, 0.91) as `p091`,
    PERCENTILE(Measure, 0.92) as `p092`,    
    PERCENTILE(Measure, 0.93) as `p093`,
    PERCENTILE(Measure, 0.94) as `p094`,
    PERCENTILE(Measure, 0.95) as `p095`,
    PERCENTILE(Measure, 0.96) as `p096`,
    PERCENTILE(Measure, 0.97) as `p097`,
    PERCENTILE(Measure, 0.98) as `p098`,
    PERCENTILE(Measure, 0.99) as `p099`
from $tmp
group by `Date`
;

