use arnold;

-- pragma yt.AutoMerge="disabled";
-- pragma yt.Pool="robot-webmaster";
pragma yt.InferSchema='1';

$univarsal_rivals = 
select Rival 
from 
(
    select Rival, count(Host) as cnt
    from range(`//home/webmaster/prod/searchqueries/niche/import/rival_queries_report`)
    group by Rival
    order by cnt desc
    limit 500
)
where Rival != ""
;

$table_with_dates = 
select Host, Rival, TableName(TablePath()) as `Date`
from range(`//home/webmaster/prod/searchqueries/niche/import/rival_queries_report`)
;

$counts_per_date = 
select `Date`, count(*) as Count
from $table_with_dates
group by `Date`
;

insert into `//home/webmaster/prod/analytics/niche/universal_stats` with truncate
select cpd.`Date` as `Date`, dh.Universal_count as un_count, cpd.Count as total_count 
from (
    select `Date`, count(Host) as Universal_count
    from (
        select * 
        from $table_with_dates as a
        inner join $univarsal_rivals as b
        on a.Rival = b.Rival
    ) 
    group by `Date`
) as dh
inner join $counts_per_date as cpd
on dh.`Date` = cpd.`Date`
;