use arnold;

-- pragma yt.AutoMerge="disabled";
-- pragma yt.Pool="robot-webmaster";
pragma yt.InferSchema='1';

$table =
select Host, Rival, RegionId, Popularity, TableName(TablePath()) as `Date`
from range(`//home/webmaster/prod/searchqueries/niche/import/rival_queries_report`)
;

$table_hosts =
select total.`Date` as `Date`, total.`Host` as `Host`
from (
    select distinct `Date`, `Host`
    from $table 
) as total
left join (
    select distinct `Date`, `Host`
    from $table
    where `Host` = `Rival`
) as having_rival
on total.`Date` = having_rival.`Date` and total.`Host` = having_rival.`Host`
;

$tmp_visibility =
select a.`Date` as `Date`, a.Host as Host, a.LocalMeasure / b.TotalMeasure as Measure
from (
    select `Date`, Host, sum(Popularity) as LocalMeasure
    from $table
    where `Rival` = Host
    group by `Date`, Host
    order by `Date`, Host
) as a
inner join (
    select `Date`, Host, sum(Popularity)  as TotalMeasure
    from $table
    where `Rival` = ""
    group by `Date`, Host
    order by `Date`, Host
) as b
on a.`Date` = b.`Date` and a.`Host` = b.`Host`
;

insert into `//home/webmaster/prod/analytics/niche/visibility_stat` WITH TRUNCATE 
select `Date`,
    PERCENTILE(Measure, 0.10) as `p010`,
    PERCENTILE(Measure, 0.20) as `p020`,
    PERCENTILE(Measure, 0.30) as `p030`,
    PERCENTILE(Measure, 0.40) as `p040`,
    PERCENTILE(Measure, 0.50) as `p050`,
    PERCENTILE(Measure, 0.60) as `p060`,
    PERCENTILE(Measure, 0.70) as `p070`,
    PERCENTILE(Measure, 0.80) as `p080`,
    PERCENTILE(Measure, 0.90) as `p090`,
    PERCENTILE(Measure, 0.91) as `p091`,
    PERCENTILE(Measure, 0.92) as `p092`,    
    PERCENTILE(Measure, 0.93) as `p093`,
    PERCENTILE(Measure, 0.94) as `p094`,
    PERCENTILE(Measure, 0.95) as `p095`,
    PERCENTILE(Measure, 0.96) as `p096`,
    PERCENTILE(Measure, 0.97) as `p097`,
    PERCENTILE(Measure, 0.98) as `p098`,
    PERCENTILE(Measure, 0.99) as `p099`
from $tmp_visibility
group by `Date`
;

insert into `//home/webmaster/prod/analytics/niche/host_without_rival_in_itself` WITH TRUNCATE 
select `Date`, count(*) as cnt
from $table_hosts
group by `Date`
;