#!/bin/bash

YQL="yql --syntax-version=1"

PROD_STATE=$(yt --proxy arnold get //home/jupiter/@jupiter_meta/production_current_state --format=json)
PROD_STATE_SWITCH_TIME=$(yt --proxy arnold get //home/jupiter/@jupiter_meta/production_current_state_switch_time --format=json)
TIMESTAMP=$(date +%s)

echo "{\"Timestamp\": $TIMESTAMP, \"production_current_state\": $PROD_STATE, \"production_current_state_switch_time\": $PROD_STATE_SWITCH_TIME}" | \
    yt --proxy arnold write "<append=true>//home/webmaster/prod/analytics/jupiter_meta" --format=json

echo '
use arnold;
pragma yt.ForceInferSchema;

insert into `//home/webmaster/prod/analytics/jupiter_meta`
    with truncate
select `Timestamp`, production_current_state, production_current_state_switch_time
from `//home/webmaster/prod/analytics/jupiter_meta`
order by `Timestamp`
' | $YQL
