use hahn;

$input_folder   = "//home/webmaster/prod/analytics/mailings/history";
$output_tail    = "//home/webmaster/prod/analytics/robot/WMC-10758.tail";
$output         = "//home/webmaster/prod/analytics/robot/WMC-10758";
$PERIOD         = 7;

$paths = (
    select aggregate_list(Period)
    from (
        select Path as Period
        from folder($input_folder)
        where Type == "table"
        order by Period desc
        limit $PERIOD
    )
);

$data = (
    select Period, UserId, HostUrl, MainMirror, HostUrl == MainMirror as IsMainMirror
    from each($paths)
    where Visible
    group by TableName() as Period, UserId, HostUrl, MainMirror
);

$added_mm = (
    select Period, UserId, MainMirror
    from $data
    where IsMainMirror
    group by Period, UserId, MainMirror
);

$report = (
    select 
        d.Period as Period,
        d.UserId as UserId,
        HostUrl,
        d.MainMirror as MainMirror,
        IsMainMirror,
        amm.MainMirror is not null as IsMainMirrorAdded
    from $data as d
    left join $added_mm as amm
        using (Period, UserId, MainMirror)
);

$report_u = (
    select 
        Period,
        count(UserId) as UsersTotal,
        count_if(not IsMainMirrorAdded) as UsersWithNoAddedMM,
    from (
        select Period, UserId, min(IsMainMirrorAdded) as IsMainMirrorAdded
        from $report
        group by Period, UserId
    )
    group by Period
);

$report_h = (
    select 
        Period,
        count(HostUrl) as HostsTotal,
        count_if(not IsMainMirrorAdded) as HostsWithNoAddedMM,
    from (
        select Period, HostUrl, max(IsMainMirrorAdded) as IsMainMirrorAdded
        from $report
        group by Period, HostUrl
    )
    group by Period
);

$report_uh = (
    select
        Period,
        count(*) as UsersHostsTotal,
        count_if(not IsMainMirrorAdded) as UsersHostsWithNoAddedMM
    from (
        select Period, UserId, HostUrl, max(IsMainMirrorAdded) as IsMainMirrorAdded
        from $report
        group by Period, UserId, HostUrl
    )
    group by Period
);

insert into $output_tail
    with truncate
select 
    u.Period as Period,
    UsersTotal,
    UsersWithNoAddedMM,
    cast(UsersWithNoAddedMM as Float) / cast(UsersTotal as Float) as UsersWithNoAddedMMShare,
    HostsTotal,
    HostsWithNoAddedMM,
    cast(HostsWithNoAddedMM as Float) / cast(HostsTotal as Float) as HostsWithNoAddedMMShare,
    UsersHostsTotal,
    UsersHostsWithNoAddedMM,
    cast(UsersHostsWithNoAddedMM as Float) / cast(UsersHostsTotal as Float) as UsersHostsWithNoAddedMMShare,
from $report_u as u
join $report_h as h
    on u.Period == h.Period
join $report_uh as uh
    on u.Period == uh.Period
order by Period;

commit;

insert into $output with truncate
select
    Period,
    some(UsersTotal) as UsersTotal,
    some(UsersWithNoAddedMM) as UsersWithNoAddedMM,
    some(UsersWithNoAddedMMShare) as UsersWithNoAddedMMShare,
    some(HostsTotal) as HostsTotal,
    some(HostsWithNoAddedMM) as HostsWithNoAddedMM,
    some(HostsWithNoAddedMMShare) as HostsWithNoAddedMMShare,
    some(UsersHostsTotal) as UsersHostsTotal,
    some(UsersHostsWithNoAddedMM) as UsersHostsWithNoAddedMM,
    some(UsersHostsWithNoAddedMMShare) as UsersHostsWithNoAddedMMShare,
from concat($output, $output_tail)
group by Period
order by Period;
