use hahn;
pragma yt.InferSchema="1";
--pragma yt.AutoMerge="disabled";

$GetDateFromTs = ($ts) -> {
    return cast(
        DateTime::MakeDate(
            DateTime::FromMilliseconds(cast($ts as Uint64))
        ) as String
    );
};

$GetDomain = ($host) -> {
    return Url::CutWWW(Url::GetHost($host));
};

$pool = (
    select 
        Period,
        Host,
        $GetDomain(Host) as Domain,
        count(*) as Urls
    from
        `//home/webmaster/prod/analytics/robot/pools/robot-metrics_spy_log_sbr_webmaster_samples_main_2_users`
    group by
        $GetDateFromTs(`date`) as Period,
        String::ToLower(Url::GetSchemeHost(canonizedUrl)) as Host
);

$in_webmaster = (
    select 
        Period,
        Host,
        $GetDomain(Host) as Domain,
        MainMirror,
    from range(`//home/webmaster/prod/analytics/mailings/history`, `2020-11-11`)
    where Visible
    group by 
        TableName() as Period,
        HostUrl as Host,
        MainMirror
);

$host_stats = (
    select
        p.Period as Period,
        p.Host as Host,
        some(p.Domain) as Domain,
        max(w.Host is not null) as InWebmaster,
        max(w2.Domain is not null) as ReachableByDomain,
        max(w3.MainMirror is not null) as ReachableByMainMirror,
        max(p.Urls) as Urls
    from $pool as p
    left join $in_webmaster as w
        on p.Period == w.Period
        and p.Host == w.Host
    left join $in_webmaster as w2
        on p.Period == w2.Period
        and p.Domain == w2.Domain
    left join $in_webmaster as w3
        on p.Period == w3.Period
        and p.Host == w3.MainMirror
    group by
        p.Period as Period,
        p.Host as Host
);

$period_stats = (
    select 
        Period,
        sum(Urls) as UrlsTotal,
        sum_if(Urls, InWebmaster) as UrlsInWebmaster,
        sum_if(Urls, not InWebmaster) as UrlsLoss,
        sum_if(Urls, not InWebmaster and ReachableByDomain) as UrlsRecoverableByDomain,
        sum_if(Urls, not InWebmaster and ReachableByMainMirror and not ReachableByDomain) as UrlsRecoverableByMainMirror
    from $host_stats
    group by Period
);

$shares = (
    select 
        Period,
        cast(UrlsInWebmaster as Float) / cast(UrlsTotal as Float) as ShareInWebmaster,
        cast(UrlsLoss as Float) / cast(UrlsTotal as Float) as ShareLoss,
        cast(UrlsRecoverableByDomain as Float) / cast(UrlsLoss as Float) as ShareRecoverableByDomain,
        cast(UrlsRecoverableByMainMirror as Float) / cast(UrlsLoss as Float) as ShareRecoverableByMainMirror,
    from $period_stats
    where Period >= '2021-03-03'
);

insert into `//home/webmaster/prod/analytics/robot/WMC-11046`
    with truncate
select *
from $shares
order by Period;

insert into `//home/webmaster/prod/analytics/robot/WMC-11046-stats`
    with truncate
select *
from $period_stats;

insert into `//home/webmaster/prod/analytics/robot/WMC-11046-hosts`
    with truncate
select *
from $host_stats;
