use hahn;

PRAGMA yt.Pool = 'robot-webmaster';

$date_parser = DateTime::Parse("%Y-%m-%d");

$basename = ($path) -> {
    $last_slash_pos = CAST(String::ReverseFind($path, "/") AS Uint64);
    RETURN String::Substring($path, $last_slash_pos + 1);
};

$max_available_date = (
    select MAX($basename(Path)) from FOLDER('//home/logfeller/logs/visit-v2-log/1d')
    where Type = 'table'
);

$calc_query_param = (
    select AGGREGATE_LIST(AsStruct(s.form_id as form_id, s.label as label, $max_available_date as date_from, $max_available_date as date_to))
    from `//home/webmaster/prod/analytics/survey/survey` as s
    left join (select query_name as label, MAX(`date`) as `date` from `//home/webmaster/prod/analytics/survey/survey_stat` group by query_name) as ss on ss.label = s.label
    where DateTime::MakeDate($date_parser(s.date_from)) <= DateTime::MakeDate($date_parser($max_available_date)) and  
            DateTime::MakeDate($date_parser($max_available_date)) <= DateTime::MakeDate($date_parser(s.date_to))
            and (ss.`date` is null or DateTime::MakeDate($date_parser($max_available_date)) > ss.`date`)
);

--Вот тут считаем показы
DEFINE SUBQUERY $show($dayFrom,$dayTo,$formId) AS 
    select `date`,
        count(VisitID) as cnt,
        count_if(ListHas(Yson::ConvertToInt64List(Goals_ID),65211490)) as cnt_show, 
        count_if(ListHas(Yson::ConvertToInt64List(Goals_ID),65211721)) as cnt_open,
        count_if(ListHas(Yson::ConvertToInt64List(Goals_ID),66592984)) as cnt_hide,
        count_if(ListHas(Yson::ConvertToInt64List(Goals_ID),66782463)) as cnt_close
        
    from (
        select  VisitID, 
                DateTime::MakeDate(DateTime::FromSeconds(MAX_BY(UTCStartTime, (VisitVersion, -Sign)))) as `date`, 
                MAX_BY(Goals_ID, (VisitVersion, -Sign)) as Goals_ID
        from RANGE(`//home/logfeller/logs/visit-v2-log/1d`,$dayFrom, $dayTo)
            where CounterID = 30468942 and 
            ParsedParams_Key2 is not null 
            and (ListHas(Yson::ConvertToStringList(ParsedParams_Key2),$formId))
        group by VisitID
        having MAX_BY(Sign, (VisitVersion, -Sign)) = 1
    )
    group by `date`
END DEFINE;
DEFINE SUBQUERY $event($dayFrom, $dayTo,$formId) AS 
    select  `date`, count(url) as cnt  ,COUNT_IF(Find(url,"success") > -1) as cnt_success
    from RANGE(`//home/logfeller/logs/bs-watch-log/1d`,$dayFrom, $dayTo)
    where --counterid =  '49158118' and 
    url like 'https://forms.yandex.ru/surveys/'||$formId || '/%' 
    group by DateTime::MakeDate(DateTime::FromSeconds(cast(eventtime as Uint32))) as `date`
END DEFINE;

DEFINE ACTION $calculate_survey_stat($query_param) as 
    insert into `//home/webmaster/prod/analytics/survey/survey_stat`
    select 
        $query_param.label as query_name,
        evnt.`date` as `date`,
        (evnt.cnt - evnt.cnt_success) as event_cnt ,
        evnt.cnt_success as event_success, 
        show.cnt_show as cnt_show, 
        show.cnt_open as cnt_open, 
        show.cnt_hide as cnt_hide,
        show.cnt_close as cnt_close
    from $event($query_param.date_from ,$query_param.date_to,$query_param.form_id) as evnt
    left join $show($query_param.date_from ,$query_param.date_to,$query_param.label) as show on show.`date` = evnt.`date`
END DEFINE ;
EVALUATE FOR $query_param in $calc_query_param 
    DO $calculate_survey_stat($query_param)
else 
    DO EMPTY_ACTION();
