use arnold;
pragma yt.Pool = 'robot-webmaster';
pragma yt.DefaultMaxJobFails = '1';

$printDate = DateTime::Format("%Y-%m-%d");
-- ABSENT -1, OFF 0 , ON 1
-- фиды
$feedsStatus = ($settings, $type) -> {
    $feeds = ListFilter(Yson::ConvertToList($settings.feedSettingsList), ($f) -> { return Yson::ConvertToString($f.type) == $type; });
    RETURN CASE
        WHEN ListLength($feeds) == 0 THEN -1
        WHEN ListHasItems(ListFilter($feeds, ($f) -> { return Yson::ConvertToBool($f.active); })) THEN 1
        ELSE 0
    END;
};
-- автопарсер
$autoparserStatus = ($settings) -> {
    RETURN CASE Yson::ConvertToString($settings.autoparserToggleState)
        WHEN 'ABSENT' THEN -1
        WHEN 'ON' THEN 1
        ELSE 0
    END;
};
-- автоморда
$contentAutomordaStatus = ($settings) -> {
    RETURN IF(Yson::ConvertToBool($settings.turboHostSettings.autoMorda), 1, 0);
};
-- бесконечная легнта
$contentAutorelatedStatus = ($settings) -> {
    RETURN IF(Yson::ConvertToBool($settings.turboHostSettings.autoRelated), 1, 0);
};
-- автоморда для е-коммерса
$commerceAutomordaStatus = ($settings) -> {
    RETURN IF(Yson::Contains($settings.turboHostSettings, 'eCommerceSettings') AND Yson::Contains($settings.turboHostSettings.eCommerceSettings, 'autoMorda') AND Yson::ConvertToBool($settings.turboHostSettings.eCommerceSettings.autoMorda), 1, 0);
};
-- листинги для е-коммерса
$commerceListingsStatus = ($settings) -> {
    RETURN IF(Yson::Contains($settings.turboHostSettings, 'eCommerceSettings') AND Yson::ConvertToBool($settings.turboHostSettings.eCommerceSettings.turboListingsEnabled), 1, 0);
};

-- настроена ли аналитика
$analyticsStatus = ($settings) -> {
    RETURN IF(Yson::Contains($settings.turboHostSettings, 'analyticsSettings') AND ListHasItems(Yson::ConvertToList($settings.turboHostSettings.analyticsSettings)), 1, 0);
};

-- настроена ли реклама
$advertisingStatus = ($settings) -> {
    RETURN IF(Yson::Contains($settings.turboHostSettings, 'advertisingSettings') AND ListHasItems(Yson::ConvertToList($settings.turboHostSettings.analyticsSettings)), 1, 0);
};

-- включена ли Турбо-корзина
$turboCartStatus = ($settings) -> {
    RETURN IF(Yson::Contains($settings.turboHostSettings, 'eCommerceSettings') AND Yson::ConvertToBool($settings.turboHostSettings.eCommerceSettings.cartUrlEnabled) == False AND
	(Yson::ConvertToBool($settings.turboHostSettings.eCommerceSettings.turboCartEnabled) OR Yson::ConvertToBool($settings.turboHostSettings.eCommerceSettings.checkoutEmailEnabled)), 1, 0);
};

-- включены ли Оплаты
$paymentsStatus = ($settings) -> {
    RETURN IF(Yson::Contains($settings.turboHostSettings, 'eCommerceSettings') AND Yson::Contains($settings.turboHostSettings.eCommerceSettings, 'paymentsSettings') AND Yson::ConvertToBool($settings.turboHostSettings.eCommerceSettings.paymentsSettings.enabled), 1, 0);
};

-- включена ли интеграция с Битриксом
$bitrixStatus = ($settings) -> {
    RETURN IF(Yson::Contains($settings.turboHostSettings, 'eCommerceSettings') AND Yson::Contains($settings.turboHostSettings.eCommerceSettings, 'bitrixSettings') AND Yson::ConvertToBool($settings.turboHostSettings.eCommerceSettings.bitrixSettings.enabled), 1, 0);
};

$oldCartUrl = ($settings) -> {
    RETURN IF(Yson::Contains($settings.turboHostSettings, 'eCommerceSettings') and Yson::Contains($settings.turboHostSettings.eCommerceSettings, 'cartUrl'), Yson::ConvertToString($settings.turboHostSettings.eCommerceSettings.cartUrl), null);
};

$customizeSettings = ($settings) -> {
    RETURN IF(Yson::Contains($settings.turboHostSettings, 'displaySettings') and Yson::Contains($settings.turboHostSettings.displaySettings, 'enabled') AND Yson::ConvertToBool($settings.turboHostSettings.displaySettings.enabled), 1, 0);
};

$customizeSettingsDesktop = ($settings) -> {
    RETURN IF(Yson::Contains($settings, 'turboDesktopSettings') and Yson::Contains($settings.turboDesktopSettings, 'displaySettings') and Yson::Contains($settings.turboDesktopSettings.displaySettings, 'enabled') AND Yson::ConvertToBool($settings.turboDesktopSettings.displaySettings.enabled), 1, 0);
};

$cssSettings = ($settings) -> {
    RETURN IF(Yson::Contains($settings.turboHostSettings, 'css') and $customizeSettings($settings) == 0, 1, 0);
};

$cssSettingsDesktop = ($settings) -> {
    RETURN IF(Yson::Contains($settings, 'turboDesktopSettings') and Yson::Contains($settings.turboDesktopSettings, 'css') and $customizeSettingsDesktop($settings) == 0, 1, 0);
};


$bitrixOwners = (
    select Owner from `//home/webmaster/prod/experiments/domain/cms_bitrix` as bx
    group by Url::GetOwner(bx.Domain) as Owner
);

INSERT INTO @FEATURES_HISTORY WITH TRUNCATE
SELECT Day, Owner,
    max($feedsStatus(Settings, 'RSS')) as RssStatus,
    max($feedsStatus(Settings, 'YML')) as YmlStatus,
    max($autoparserStatus(Settings)) as AutoparserStatus,
    max($contentAutomordaStatus(Settings)) as ContentAutomordaStatus,
    max($commerceAutomordaStatus(Settings)) as CommerceAutomordaStatus,
    max($contentAutorelatedStatus(Settings)) as ContentAutorelatedStatus,
    max($commerceListingsStatus(Settings)) as CommerceListingsStatus,
    max($analyticsStatus(Settings)) as AnalyticsStatus,
    max($advertisingStatus(Settings)) as AdvertisingStatus,
    max($turboCartStatus(Settings)) as TurboCartStatus,
    max($paymentsStatus(Settings)) as PaymentsStatus,
    max($bitrixStatus(Settings)) as BitrixStatus,
    some($oldCartUrl(Settings)) as OldCartUrl,
    max($customizeSettings(Settings)) as CustomizeSettings,
    max($customizeSettingsDesktop(Settings)) as CustomizeSettingsDesktop,
    max($cssSettings(Settings)) as CssSettings,
    max($cssSettingsDesktop(Settings)) as CssSettingsDesktop
FROM `//home/webmaster/prod/analytics/turbo/settings-history`
GROUP BY Day, Url::GetOwner(Domain) as Owner
ORDER BY Day, Owner
;

commit;

$ownerStatuses = (
    SELECT Day, Owner,
        RssStatus, LAG(RssStatus) OVER w AS PrevRssStatus,
        YmlStatus, LAG(YmlStatus) OVER w AS PrevYmlStatus,
        AutoparserStatus, LAG(AutoparserStatus) OVER w as PrevAutoparserStatus,
        ContentAutomordaStatus, LAG(ContentAutomordaStatus) OVER w as PrevContentAutomordaStatus,
        CommerceAutomordaStatus, LAG(CommerceAutomordaStatus) OVER w as PrevCommerceAutomordaStatus,
        CommerceListingsStatus, LAG(CommerceListingsStatus) OVER w as PrevCommerceListingsStatus,
        AnalyticsStatus, LAG(AnalyticsStatus) OVER w as PrevAnalyticsStatus,
        AdvertisingStatus, LAG(AdvertisingStatus) OVER w as PrevAdvertisingStatus,
        TurboCartStatus, LAG(TurboCartStatus) OVER w as PrevTurboCartStatus,
        PaymentsStatus, LAG(PaymentsStatus) OVER w as PrevPaymentsStatus,
        BitrixStatus, LAG(BitrixStatus) OVER w as PrevBitrixStatus,
        OldCartUrl, LAG(OldCartUrl) OVER w as PrevOldCartUrl
    FROM @FEATURES_HISTORY
    WINDOW w AS (
        PARTITION BY Owner
        ORDER BY Day
    )
);

insert into `//home/webmaster/prod/analytics/turbo/features_turned_on` with truncate
select Week,
    count_if(RssStatus == 1 and PrevRssStatus <> 1) as RssOn,
    count_if(YmlStatus == 1 and PrevYmlStatus <> 1) as YmlOn,
    count_if(AutoparserStatus == 1 and PrevAutoparserStatus <> 1) as AutoparserOn,
    count_if(ContentAutomordaStatus == 1 and PrevContentAutomordaStatus <> 1) as ContentAutomordaOn,
    count_if(CommerceAutomordaStatus == 1 and PrevCommerceAutomordaStatus <> 1) as CommerceAutomordaOn,
    count_if(CommerceListingsStatus == 1 and PrevCommerceListingsStatus <> 1) as CommerceListingsOn,
    count_if(AnalyticsStatus == 1 and PrevAnalyticsStatus <> 1) as AnalyticsOn,
    count_if(AdvertisingStatus == 1 and PrevAdvertisingStatus <> 1) as AdvertisingOn,
    count_if(TurboCartStatus == 1 and PrevTurboCartStatus <> 1) as TurboCartOn,
    count_if(PaymentsStatus == 1 and PrevPaymentsStatus <> 1) as PaymentsOn,
    count_if(BitrixStatus == 1 and PrevBitrixStatus <> 1) as BitrixOn,
    count_if(OldCartUrl <> PrevOldCartUrl) as OldCartUrlChanged
from $ownerStatuses as status
group by DateTime::MakeDate(DateTime::StartOfWeek(DateTime::ParseIso8601(Day))) as Week
order by Week;

$rawStat = (
    SELECT Day,
        count_if(YmlStatus == 1) as Total,
        count_if(YmlStatus == 1 and TurboCartStatus == 1) as TurboCartOn,
        count_if(YmlStatus == 1 and PaymentsStatus == 1) as PaymentsOn,
        count_if(YmlStatus == 1 and BitrixStatus == 1) as BitrixOn,
        count_if(YmlStatus == 1 and b.Owner is not null) as BitrixTotal
    FROM @FEATURES_HISTORY as s
    LEFT JOIN $bitrixOwners as b
    ON s.Owner == b.Owner
    GROUP BY s.Day as Day
    ORDER BY Day
);

insert into `//home/webmaster/prod/analytics/turbo/features_share` with truncate
select Day,
    TurboCartOn as TurboCartOnCount,
    PaymentsOn as PaymentsOnCount,
    BitrixOn as BitrixOnCount,
    BitrixTotal as BitrixCount,
    Total,
    100.0 * TurboCartOn / Total as TurboCartOn,
    100.0 * PaymentsOn / Total as PaymentsOn,
    100.0 * BitrixOn / BitrixTotal as BitrixOn,
    100.0 * BitrixOn / Total as BitrixOnTotal
from
    $rawStat
order by Day;

insert into `//home/webmaster/prod/analytics/turbo/custom_settings` with truncate
SELECT Day,
-- hosts with enabled content turbo
        count_if(CustomizeSettings == 1 and RssStatus == 1) as CustomTurboDomainSettingsWithRss,
        count_if(CustomizeSettingsDesktop == 1 and RssStatus == 1) as CustomTurboDesktopSettingsWithRss,
        count_if(CssSettings == 1 and RssStatus == 1) as CssTurboDomainSettingsWithRss,
        count_if(CssSettingsDesktop == 1 and RssStatus == 1) as CssTurboDesktopSettingsWithRss,
-- all hosts
        count_if(CustomizeSettings == 1) as CustomTurboDomainSettings,
        count_if(CustomizeSettingsDesktop == 1) as CustomTurboDesktopSettings,
        count_if(CssSettings == 1) as CssTurboDomainSettings,
        count_if(CssSettingsDesktop == 1) as CssTurboDesktopSettings,
FROM @FEATURES_HISTORY
WHERE Day >= "2021-01-20"
GROUP BY Day as Day
ORDER BY Day