use arnold;

pragma yt.Pool = 'robot-webmaster';

$printDate = DateTime::Format("%Y-%m-%d");
$parseDate = DateTime::Parse("%Y-%m-%d");

$lastProcessedTable = (select max(TableName(Path)) from folder(`//home/webmaster/prod/analytics/turbo/settings-history-by-days`) where Type == 'table');

$historyTables = (
select AGGREGATE_LIST(Path) from
(
    select Path from FOLDER("//home/logfeller/logs/webmaster-prod-processed-events-log/1d", "schema;row_count") where Type == 'table'
    and TableName(Path) > $lastProcessedTable order by Path asc limit 500
)
);

EVALUATE FOR $historyTable IN $historyTables DO BEGIN
    $curDay = TableName($historyTable);
    $prevDay = $printDate(DateTime::MakeDate($parseDate($curDay)) - DateTime::IntervalFromDays(1));
    $curTable = '//home/webmaster/prod/analytics/turbo/settings-history-by-days/' || $curDay;
    $prevTable = '//home/webmaster/prod/analytics/turbo/settings-history-by-days/' || $prevDay;
    insert into $curTable
    select TableName($historyTable) as Day, Domain, max_by(Settings, Day) as Settings from
    (
        select Day, Domain, max_by(content, created) as Settings
        from $historyTable
        where type in ('TURBO_SETTINGS_CHANGE', 'turboSettingsChangeEvent')
        group by $printDate(DateTime::FromMilliseconds(created)) as Day, Yson::ConvertToString(content.domain) as Domain
        union all
        select Day, Domain, Settings from $prevTable
    )
    group by Domain;
    commit;

    insert into `//home/webmaster/prod/analytics/turbo/settings-history`
    select Day, Domain, Settings FROM $curTable
    order by Day, Domain;
    commit;
END DO;