use arnold;

$paths = (
    select aggregate_list(Path)
    from (
        select Unwrap(Path) as Path
        from folder(`//home/webmaster/prod/searchqueries/user_sessions/statistics/daily`)
        order by Path desc 
        limit 28
    )
);

insert into `//home/webmaster/prod/export/analytics/user_sessions/28d-hosts`
    with truncate
select 
    Host,
    sum(Clicks) as Clicks,
    sum(Shows) as Shows
from each($paths)
where RequestSource in (0,1,2,3,4,5,6)
    and ResultSource in (0,2)
group by Host
order by Host
