use hahn;
pragma yt.Pool="robot-webmaster";

$input_folder   = "//logs/bs-chevent-log/1d";
$output_tail    = "//home/webmaster/prod/analytics/catalogia/bs-chevent-log.tail";
$output         = "//home/webmaster/prod/analytics/catalogia/bs-chevent-log";
$today          = CurrentUTCDate();
$format         = DateTime::Format("%Y-%m-%d");
$days_count     = 3;

$paths = (
    select ListMap(ListFromRange(1, $days_count + 1), ($index) -> {
        $day = $today - $index * DateTime::IntervalFromDays(1);
        $path = $input_folder || "/" || $format($day);
        return Unwrap($path);
    })
);

insert into $output_tail
    with truncate
select
    period,
    contexttype,
    simdistance,
    sum(cast(eventcost as double)) / 1000000.0 as units
from each($paths)
where fraudbits == "0"
    and contexttype in ("7", "8")
group by
    TableName() as period,
    contexttype,
    simdistance
order by 
    period,
    contexttype,
    simdistance
;

commit;

insert into $output
    with truncate
select 
    period,
    contexttype,
    simdistance,
    some(units) as units
from concat(
    $output_tail,
    $output
)
group by
    period,
    contexttype,
    simdistance
order by
    period,
    contexttype,
    simdistance
;
