use arnold;
pragma yt.Pool="robot-webmaster";
pragma yt.ForceInferSchema;

$today = cast(CurrentUtcDate() as String);

$output_tail    = "//home/webmaster/prod/analytics/catalogia/exports.tail";
$output         = "//home/webmaster/prod/analytics/catalogia/exports";

$user_sessions = (
    select
        $today as Period,
        count(*) as UserSessionsQueries,
    from (
        select QueryId
        from `//home/webmaster/prod/export/catalogia/queries-v2`
        group by QueryId
    )
);

insert into $output_tail
    with truncate
select
    us.Period as Period,
    UserSessionsQueries,
    0 as UserSessionsUrls,
    0 as WMClustersQueries,
    0 as WMClustersUrls
from $user_sessions as us;

commit;

insert into $output
    with truncate
select 
    Period,
    max(UserSessionsQueries)    as UserSessionsQueries,
    max(UserSessionsUrls)       as UserSessionsUrls,
    max(WMClustersQueries)      as WMClustersQueries,
    max(WMClustersUrls)         as WMClustersUrls,
from concat(
    $output_tail,
    $output
)
group by
    Period
order by
    Period
