use arnold;

$date = ($date) -> {
    return DateTime::MakeDate(DateTime::StartOfDay(DateTime::FromMilliseconds(Cast($date as Uint64))))
};

$offersPerDay = (
select date, count(date) as amount
from `//home/webmaster/prod/export/videohostings/videohost_offers_current`
group by $date(`AddDate`) as date
);

$confirmedOffersPerDay = (
select date, count(date) as amount
from `//home/webmaster/prod/export/videohostings/videohost_offers_history`
where `Status`='CONFIRMED'
or `Status`='HAS_PAPER'
or `Status`='REDUNDANT'
group by $date(`UpdateDate`) as date
);

$offersAgregate = (select a.date as date, sum(b.amount) as amount
from $offersPerDay as a cross join $offersPerDay as b
where b.date <= a.date
group by a.date);

$confirmedOffersAgregate = (select a.date as date, sum(b.amount) as amount
from $confirmedOffersPerDay as a cross join $confirmedOffersPerDay as b
where b.date <= a.date
group by a.date);

$dates = (
    select distinct date, of, con
    from (
        select date, amount as of from $offersAgregate
        union all
        select date, amount as con from $confirmedOffersAgregate
    )
    
);

select date, sum(of) as offers, sum(con) as confirmed
from $dates
group by date
order by date;
