#pragma once

#include <util/generic/singleton.h>
#include <util/generic/string.h>

#include <wmconsole/version3/library/env/yt.h>
#include <wmconsole/version3/searchqueries-mr/conf/yt.h>

namespace NWebmaster {

struct TConfig {
    static const TConfig &CInstance() {
        return *Singleton<TConfig>();
    }

    TConfig() {
        const TProdYTEnvironment prodEnv;
        MR_SERVER_HOST                       = "arnold.yt.yandex.net";

        TABLE_ANTIALL_ROOT                   = NYTUtils::JoinPath(prodEnv.TABLE_ENV_ROOT, "antiall");
        TABLE_ANTIALL_TMP_ROOT               = NYTUtils::JoinPath(prodEnv.TABLE_ENV_ROOT, "tmp/antiall");
        TABLE_SNAPSHOT                       = NYTUtils::JoinPath(TABLE_ANTIALL_ROOT, "snapshot");
        TABLE_PREV_SNAPSHOT                  = NYTUtils::JoinPath(TABLE_ANTIALL_ROOT, "prev-snapshot");
        TABLE_CHANGES_ROOT                   = NYTUtils::JoinPath(TABLE_ANTIALL_ROOT, "changes");
        TABLE_NOTIFICATIONS_ROOT             = NYTUtils::JoinPath(TABLE_ANTIALL_ROOT, "notifications");
        TABLE_WEBMASTER_HOSTS                = NYTUtils::JoinPath(prodEnv.TABLE_ENV_ROOT, "export/webmaster-hosts");
        TABLE_ANTISPAM_SOURCE                = "//home/antispam/export/webmaster/threats";
        TABLE_ANTIVIR_SOURCE                 = "//home/antivir/prod/export/urls_for_webmaster";
        TABLE_ANTISPAM_PROCESSED             = NYTUtils::JoinPath(TABLE_ANTIALL_ROOT, "antispam-processed");
        TABLE_ANTIVIR_PROCESSED              = NYTUtils::JoinPath(TABLE_ANTIALL_ROOT, "antivir-processed");

        ATTR_ANTISPAM_SOURCE_DATE            = "antispam_source_date";
        ATTR_ANTIVIR_SOURCE_DATE             = "antivir_source_date";
    }

public:
    TString MR_SERVER_HOST;
    TString TABLE_ANTIALL_ROOT;
    TString TABLE_ANTIALL_TMP_ROOT;
    TString TABLE_SNAPSHOT;
    TString TABLE_PREV_SNAPSHOT;
    TString TABLE_CHANGES_ROOT;
    TString TABLE_NOTIFICATIONS_ROOT;
    TString TABLE_WEBMASTER_HOSTS;
    TString TABLE_ANTISPAM_SOURCE;
    TString TABLE_ANTIVIR_SOURCE;
    TString TABLE_ANTISPAM_PROCESSED;
    TString TABLE_ANTIVIR_PROCESSED;

    TString ATTR_ANTISPAM_SOURCE_DATE;
    TString ATTR_ANTIVIR_SOURCE_DATE;
};

} //namespace NWebmaster
