#pragma once

#include <util/generic/string.h>
#include <util/generic/buffer.h>
#include <util/generic/hash_set.h>

#include <library/cpp/containers/comptrie/comptrie.h>

#include <wmconsole/version3/protos/antispam.pb.h>

namespace NWebmaster {

struct TThreatSettings {
    TString ThreatName;
    TString DisplayName;
    proto::DisplayMode DisplayMode;
    bool DisplayModeSet = false;
    TString Sanction;
    bool SanctionSet = false;
    bool Show = false;
    bool ShowSet = false;
};

struct TThreatsConfig {
    using TThreatsTrie = TCompactTrie<char, size_t>;

    TThreatsConfig();

    TThreatsConfig(const void* data, size_t size, const THashSet<TString>& displayableThreats)
        : DisplayableThreats(displayableThreats)
    {
        AddThreatsJson(data, size);
        SaveThreats();
    }

    static const TThreatsConfig &CInstance() {
        return *Singleton<TThreatsConfig>();
    }

    bool FindMatchingThreat(const TString &threatName, TThreatSettings *matchingThreat) const;

    bool FindExactThreat(const TString &threatName, TThreatSettings *threat) const;

    size_t Size() const;

    const TVector<TThreatSettings>& GetInvalidThreatSettings() const {
        return InvalidThreatSettings;
    }

private:
    void AddThreatsJson(const void* data, size_t size);
    void SaveThreats();

    TBuffer ThreatsTrieBuffer;
    TThreatsTrie ThreatsTrie;
    TVector<TThreatSettings> ThreatSettings;
    THashSet<TString> DisplayableThreats;
    TVector<TThreatSettings> InvalidThreatSettings;
};

} //namespace NWebmaster
