#!/usr/bin/env bash

export YT_TOKEN_PATH="secrets/prod"
export YQL_TOKEN=$(cat yql_secrets/prod)
export YT_TOKEN=$(cat $YT_TOKEN_PATH)
export YP_TOKEN_PATH="secrets_misc/YP_TOKEN"
export YP_TOKEN=$(cat $YP_TOKEN_PATH)
export SOLOMON_TOKEN=$(cat secrets_misc/SOLOMON_TOKEN)
export STARTREK_TOKEN=$(cat secrets_misc/STARTREK_TOKEN)
export REACTOR_TOKEN=$(cat secrets_misc/REACTOR_TOKEN)
export METRIKA_CH_PASSWORD=$(cat secrets_misc/METRIKA_CH_PASSWORD)
export SVN_SSH="ssh -i secrets_keys/id_rsa -o 'StrictHostKeyChecking no'"
set -xue -o posix -o pipefail

_scenario() {
    MAIN    = !hostlist:main
}

#!+INCLUDES

. acceptance/cm_main.sh

. acceptance/sql/cm_main.sh

. achievements/cm_main.sh

. analytics/cm_main.sh

. antiall/cm_main.sh

. digest/cm_main.sh

. favicons/cm_main.sh

. feeds/cm_main.sh

. indexing/cm_main.sh

. legacy/cm_main.sh

. links/cm_main.sh

. seocheck/cm_main.sh

. sitemaps/cm_main.sh

. siteservices/cm_main.sh

. tools/cm_main.sh

. turbo/shops/cm_main.sh

. turbo/state/cm_main.sh

. turbo/statistics/cm_main.sh

. turbo/url/cm_main.sh

. user_sessions/cm_main.sh

#!-INCLUDES

"$@"
