#include <wmconsole/version3/wmcutil/yt/yt_runner.h>

#include "config.h"
#include "monitor.h"
#include "checklist.h"

namespace NWebmaster {

namespace {
const char *F_HOST      = "Host";
}

void PrepareCheckListSource(NYT::IClientBasePtr clientSearch) {
    const auto &config = TConfig::CInstance();

    NYT::ITransactionPtr tx = clientSearch->StartTransaction();

    TDeque<NYTUtils::TTableInfo> tables;
    NYTUtils::GetTableList(tx, config.TABLE_SOURCE_CHECKLIST_PREFIX, tables);

    TOpRunner runner(tx);
    for (const NYTUtils::TTableInfo &table : tables) {
        if (!NYTUtils::IsTableSorted(tx, table.Name)) {
            runner
                .SortBy(F_HOST)
                .Sort(table.Name, ASYNC_CTX0)
            ;
        }
    }
    runner.Wait(ASYNC_CTX0);

    tx->Commit();
}

} //namespace NWebmaster
