#pragma once

#include <util/generic/singleton.h>

#include <wmconsole/version3/library/conf/yt.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {

struct TConfig {
    static TConfig &Instance() {
        return *Singleton<TConfig>();
    }

    static const TConfig &CInstance() {
        return Instance();
    }

    TConfig() {
        MONITOR_PERFORMANCE_SUFFIX                  = TCommonYTConfig::CInstance().MONITOR_PERFORMANCE_SUFFIX;
        MR_SERVER_HOST_QUERIES                      = "arnold.yt.yandex.net";
        MR_SERVER_HOST_SEARCH                       = "arnold.yt.yandex.net";
        MR_SERVER_HOST_REVIEWS                      = "hahn.yt.yandex.net";

        BEAUTYURL_HANDLER                           = "http://webmaster-canonizer.n.yandex.ru/getCaseHost?json=true";
        GEO_REGIONS_HANDLER                         = "http://webmaster-geo.n.yandex.ru/getGeoData";

        TABLE_EXPORT_ROOT                           = TCommonYTConfig::CInstance().TABLE_EXPORT_ROOT;
        TABLE_ROOT                                  = TCommonYTConfig::CInstance().TABLE_ROOT;
        TABLE_TEMP_ROOT                             = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_TEMP_ROOT, "digest");
        TABLE_DIGEST_ROOT                           = NYTUtils::JoinPath(TABLE_ROOT, "digest");

        TABLE_SOURCE_CHECKLIST_PREFIX               = NYTUtils::JoinPath(TABLE_ROOT, "checklist/site-problems");
        TABLE_SOURCE_QUERIES_CONVERTED_PREFIX       = NYTUtils::JoinPath(TABLE_ROOT, "searchqueries/converted_v4");
        TABLE_SOURCE_QUERIES_FAVORITES              = NYTUtils::JoinPath(TABLE_ROOT, "searchqueries/reports_v4/favorite_queries");
        TABLE_SOURCE_QUERIES_GROUPS_PREFIX          = NYTUtils::JoinPath(TABLE_ROOT, "searchqueries/reports_v4/groups");
        TABLE_SOURCE_QUERIES_TOPS                   = NYTUtils::JoinPath(TABLE_ROOT, "searchqueries/reports_v4/top_3month.top");
        TABLE_SOURCE_RECRAWL                        = NYTUtils::JoinPath(TABLE_ROOT, "import/merged-recrawl-results");
        TABLE_SOURCE_SEARCH_IMPORTANT_URLS          = NYTUtils::JoinPath(TABLE_ROOT, "important_urls/snapshot");
        TABLE_SOURCE_SEARCH_HISTORY                 = NYTUtils::JoinPath(TABLE_ROOT, "sitetree/search/history.wmc.new_gone.acceptance");
        TABLE_SOURCE_SEARCH_SITETREE_PREFIX         = NYTUtils::JoinPath(TABLE_ROOT, "sitetree");
        TABLE_SOURCE_USER_SETTINGS_QUERIES_GROUPS   = NYTUtils::JoinPath(TABLE_ROOT, "user/query_groups");
        TABLE_SOURCE_USER_SETTINGS_CHANNELS                  = NYTUtils::JoinPath(TABLE_ROOT, "user/user-notification-settings/user-notification-channel-settings");

        TABLE_SOURCE_SEARCH_BASES                   = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "searchbases");
        TABLE_SOURCE_USER_VERIFICATIONS_PREFIX      = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "archive/webmaster-verified-hosts");
        TABLE_SOURCE_WEBMASTER_HOSTS                = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "webmaster-hosts");

        TABLE_SOURCE_IKS                            = NYTUtils::JoinPath(TABLE_ROOT, "iks/IKS");
        TABLE_SOURCE_ACHIEVEMENTS                   = NYTUtils::JoinPath(TABLE_ROOT, "achievements/achievements");
        TABLE_SOURCE_ACHIEVEMENTS_KUUB              = NYTUtils::JoinPath(TABLE_ROOT, "achievements/achievements.kuub");

        TABLE_SOURCE_REVIEWS                        = "//home/robot-ugc/export/saas/reviews/sites_reviews";
        TABLE_SOURCE_JUPITER_EXPORT                 = "//home/jupiter/export";

        TABLE_DIGEST_REPORT_PART_QUERIES            = NYTUtils::JoinPath(TABLE_DIGEST_ROOT, "report", "part", "queries");
        TABLE_DIGEST_REPORT_PART_SEARCH             = NYTUtils::JoinPath(TABLE_DIGEST_ROOT, "report", "part", "search");
        TABLE_DIGEST_REPORT_PART_QUERIES_DEBUG      = NYTUtils::JoinPath(TABLE_DIGEST_ROOT, "report", "debug", "part", "queries");
        TABLE_DIGEST_REPORT_PART_SEARCH_DEBUG       = NYTUtils::JoinPath(TABLE_DIGEST_ROOT, "report", "debug", "part", "search");
        TABLE_DIGEST_LITE_REPORT                    = NYTUtils::JoinPath(TABLE_DIGEST_ROOT, "report", "report-lite");
        TABLE_DIGEST_REPORT                         = NYTUtils::JoinPath(TABLE_DIGEST_ROOT, "report", "report");

        TABLE_DIGEST_SOURCES_ROOT                   = NYTUtils::JoinPath(TABLE_DIGEST_ROOT, "sources");
        TABLE_DIGEST_SOURCE_BEAUTYURL               = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "beautyurl");

        TABLE_DIGEST_SOURCE_GEO_REGIONS             = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "geo");

        TABLE_DIGEST_SOURCE_QUERIES_ALL             = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "queries", "all");
        TABLE_DIGEST_SOURCE_QUERIES_FAVORITES_ALL   = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "queries", "favorites", "all");
        TABLE_DIGEST_SOURCE_QUERIES_FAVORITES_SPLIT = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "queries", "favorites", "split");
        TABLE_DIGEST_SOURCE_QUERIES_GROUPS          = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "queries", "groups");
        TABLE_DIGEST_SOURCE_QUERIES_POPULAR_URLS    = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "queries", "popular_urls");
        TABLE_DIGEST_SOURCE_QUERIES_TOPS            = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "queries", "tops");
        TABLE_DIGEST_SOURCE_USER_SETTINGS_QUERIES_GROUPS    = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "queries", "groups_settings");

        TABLE_DIGEST_SOURCE_RECRAWL                 = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "recrawl");

        TABLE_DIGEST_SOURCE_SEARCH_HISTORY          = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "search", "history");
        TABLE_DIGEST_SOURCE_SEARCH_IMPORTANT_URLS   = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "search", "important_urls");
        TABLE_DIGEST_SOURCE_SEARCH_SITETREE         = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "search", "sitetree");

        TABLE_DIGEST_SOURCE_USER_SETTINGS_CHANNELS  = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "user_settings", "digest_full");
        TABLE_DIGEST_SOURCE_USER_VERIFICATIONS      = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "user_verifications");
        TABLE_DIGEST_LITE_SOURCE_USER_SETTINGS_CHANNELS = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "user_settings","digest_lite");

        TABLE_DIGEST_SOURCE_IKS                     = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "iks");
        TABLE_DIGEST_SOURCE_ACHIEVEMENTS            = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "achievements");
        TABLE_DIGEST_SOURCE_REVIEWS                 = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "reviews");
        TABLE_DIGEST_SOURCE_MIRRORS                 = NYTUtils::JoinPath(TABLE_DIGEST_SOURCES_ROOT, "mirrors");
    }

public:
    TString MONITOR_PERFORMANCE_SUFFIX;
    TString MR_SERVER_HOST_SEARCH;
    TString MR_SERVER_HOST_QUERIES;
    TString MR_SERVER_HOST_REVIEWS;

    TString BEAUTYURL_HANDLER;
    TString GEO_REGIONS_HANDLER;

    TString TABLE_ROOT;
    TString TABLE_TEMP_ROOT;
    TString TABLE_EXPORT_ROOT;

    TString TABLE_SOURCE_CHECKLIST_PREFIX;
    TString TABLE_SOURCE_QUERIES_CONVERTED_PREFIX;
    TString TABLE_SOURCE_QUERIES_FAVORITES;
    TString TABLE_SOURCE_QUERIES_GROUPS_PREFIX;
    TString TABLE_SOURCE_USER_SETTINGS_QUERIES_GROUPS;
    TString TABLE_SOURCE_QUERIES_TOPS;
    TString TABLE_SOURCE_RECRAWL;
    TString TABLE_SOURCE_SEARCH_BASES;
    TString TABLE_SOURCE_SEARCH_HISTORY;
    TString TABLE_SOURCE_SEARCH_IMPORTANT_URLS;
    TString TABLE_SOURCE_SEARCH_SITETREE_PREFIX;
    TString TABLE_SOURCE_USER_SETTINGS_CHANNELS;
    TString TABLE_SOURCE_USER_VERIFICATIONS_PREFIX;
    TString TABLE_SOURCE_WEBMASTER_HOSTS;
    TString TABLE_SOURCE_IKS;
    TString TABLE_SOURCE_ACHIEVEMENTS;
    TString TABLE_SOURCE_ACHIEVEMENTS_KUUB;
    TString TABLE_SOURCE_REVIEWS;
    TString TABLE_SOURCE_JUPITER_EXPORT;

    TString TABLE_DIGEST_ROOT;
    TString TABLE_DIGEST_SOURCES_ROOT;

    TString TABLE_DIGEST_REPORT_PART_QUERIES;
    TString TABLE_DIGEST_REPORT_PART_SEARCH;
    TString TABLE_DIGEST_REPORT_PART_QUERIES_DEBUG;
    TString TABLE_DIGEST_REPORT_PART_SEARCH_DEBUG;
    TString TABLE_DIGEST_LITE_REPORT;
    TString TABLE_DIGEST_REPORT;

    TString TABLE_DIGEST_SOURCE_BEAUTYURL;

    TString TABLE_DIGEST_SOURCE_GEO_REGIONS;

    TString TABLE_DIGEST_SOURCE_QUERIES_ALL;
    TString TABLE_DIGEST_SOURCE_QUERIES_FAVORITES_ALL;
    TString TABLE_DIGEST_SOURCE_QUERIES_FAVORITES_SPLIT;
    TString TABLE_DIGEST_SOURCE_QUERIES_GROUPS;
    TString TABLE_DIGEST_SOURCE_QUERIES_POPULAR_URLS;
    TString TABLE_DIGEST_SOURCE_QUERIES_TOPS;
    TString TABLE_DIGEST_SOURCE_USER_SETTINGS_QUERIES_GROUPS;

    TString TABLE_DIGEST_SOURCE_RECRAWL;

    TString TABLE_DIGEST_SOURCE_SEARCH_HISTORY;
    TString TABLE_DIGEST_SOURCE_SEARCH_IMPORTANT_URLS;
    TString TABLE_DIGEST_SOURCE_SEARCH_SITETREE;

    TString TABLE_DIGEST_SOURCE_USER_SETTINGS_CHANNELS;
    TString TABLE_DIGEST_LITE_SOURCE_USER_SETTINGS_CHANNELS;

    TString TABLE_DIGEST_SOURCE_USER_VERIFICATIONS;
    TString TABLE_DIGEST_SOURCE_IKS;
    TString TABLE_DIGEST_SOURCE_ACHIEVEMENTS;
    TString TABLE_DIGEST_SOURCE_REVIEWS;
    TString TABLE_DIGEST_SOURCE_MIRRORS;
};

} //namespace NWebmaster
