#include <library/cpp/string_utils/url/url.h>

#include <wmconsole/version3/wmcutil/hostid.h>
#include <wmconsole/version3/wmcutil/log.h>
#include <wmconsole/version3/wmcutil/owners.h>
#include <wmconsole/version3/wmcutil/yt/yt_runner.h>

#include "config.h"
#include "monitor.h"
#include "iks.h"

namespace NWebmaster {

const char *ATTR_UPDATE_TIME = "update_time";

void PrepareIKSSource(NYT::IClientBasePtr clientSearch, const TWeekConfig &thisWeek) {
    const auto &config = TConfig::CInstance();

    const TString IKSValuesTable = NYTUtils::JoinPath(config.TABLE_DIGEST_SOURCE_IKS, NUtils::Date2StrTZ(thisWeek.WeekEnd));
    const time_t IKSTimestamp = NYTUtils::GetAttr(clientSearch, config.TABLE_SOURCE_IKS, ATTR_UPDATE_TIME).AsInt64();

    if (clientSearch->Exists(IKSValuesTable)) {
        if (NYTUtils::GetAttr(clientSearch, IKSValuesTable, ATTR_UPDATE_TIME).AsInt64() == IKSTimestamp) {
            LOG_INFO("source iks, table is already processed");
            return;
        }
    }

    TOpRunner(clientSearch)
        .Copy(config.TABLE_SOURCE_IKS, IKSValuesTable)
    ;

    NYTUtils::SetAttr(clientSearch, IKSValuesTable, ATTR_UPDATE_TIME, IKSTimestamp);
}

} //namespace NWebmaster
