#include "monitor.h"

namespace NWebmaster {

TMonitor::TMonitor()
//    : HistoryReportSuccess("Queries_HReportSuccess")
{
}

void TMonitor::Upload() {
/*
    TMonitoringAgent<> agent;

    agent
        .Next(HistoryReportSuccess)
        .GlobalDerived()
        .Commit();
*/
}

void MonitorPushLabel(const TString &suffix, const TString &label, const TString &service, double value) {
    TSolomonPushBackend pushBackend("webmaster", "webmaster_performance_" + suffix);
    TMonitoringAgent<TSolomonPushBackend> agent(pushBackend);

    agent
        .Next(label, value)
        .GlobalService(service)
        .Commit();
}

void MonitorPushQualityLabel(const TString &suffix, const TString &label, double value) {
    MonitorPushLabel(suffix, label, "webmaster_quality", value);
}

void MonitorPushCountersLabel(const TString &suffix, const TString &label, double value) {
    MonitorPushLabel(suffix, label, "webmaster_counters", value);
}

void MonitorBeautyUrlsSourceLag(const TString &suffix, double sourceLag) {
    MonitorPushQualityLabel(suffix, "Digest_SourceLagBeautyUrls", static_cast<double>(sourceLag));
}

void MonitorGeoRegionsSourceLag(const TString &suffix, double sourceLag) {
    MonitorPushQualityLabel(suffix, "Digest_SourceLagGeoRegions", static_cast<double>(sourceLag));
}

void MonitorImportantUrlsSourceLag(const TString &suffix, double sourceLag) {
    MonitorPushQualityLabel(suffix, "Digest_SourceLagImportantUrls", static_cast<double>(sourceLag));
}

void MonitorSitetreesSourceLag(const TString &suffix, double sourceLag) {
    MonitorPushQualityLabel(suffix, "Digest_SourceLagSitetrees", static_cast<double>(sourceLag));
}

void MonitorVerifiedUsersSourceLag(const TString &suffix, double sourceLag) {
    MonitorPushQualityLabel(suffix, "Digest_SourceLagVerifiedUsers", static_cast<double>(sourceLag));
}

} //namespace NWebmaster
