#pragma once

#include <mapreduce/yt/interface/client.h>

#include "config.h"
#include "week_config.h"

namespace NWebmaster {

enum ETableType {
    E_TABLE_TYPE_UNKNOWN = -1,
    E_TABLE_TYPE_BEAUTY_URL_NEW,
    E_TABLE_TYPE_BEAUTY_URL_OLD,
    E_TABLE_TYPE_CHECKLIST_NEW,
    E_TABLE_TYPE_CHECKLIST_OLD,
    E_TABLE_TYPE_GEO_NEW,
    E_TABLE_TYPE_GEO_OLD,
    E_TABLE_TYPE_QUERIES_ALL,
    E_TABLE_TYPE_QUERIES_FAVORITES_ALL,
    E_TABLE_TYPE_QUERIES_FAVORITES_SPLIT,
    E_TABLE_TYPE_QUERIES_GROUPS,
    E_TABLE_TYPE_QUERIES_GROUPS_SETTINGS,
    E_TABLE_TYPE_QUERIES_POPULAR_URLS,
    E_TABLE_TYPE_QUERIES_TOPS,
    E_TABLE_TYPE_RECRAWL_URLS_NEW,
    E_TABLE_TYPE_SEARCH_HISTORY,
    E_TABLE_TYPE_SEARCH_IMPORTANT_URLS_NEW,
    E_TABLE_TYPE_SEARCH_IMPORTANT_URLS_OLD,
    E_TABLE_TYPE_SEARCH_SITETREE_NEW,
    E_TABLE_TYPE_SEARCH_SITETREE_OLD,
    E_TABLE_TYPE_USER_VERIFICATIONS,
    E_TABLE_TYPE_IKS_NEW,
    E_TABLE_TYPE_IKS_OLD,
    E_TABLE_TYPE_ACHIEVEMENTS_NEW,
    E_TABLE_TYPE_ACHIEVEMENTS_OLD,
    E_TABLE_TYPE_REVIEWS_NEW,
    E_TABLE_TYPE_REVIEWS_OLD,
    E_TABLE_TYPE_MIRRORS
};

void BuildDigestReport(NYT::IClientBasePtr clientQueries, NYT::IClientBasePtr clientSearch, const TDigestWeekConfig &weekConfig);
bool GetDailyTables(NYT::IClientBasePtr client, const TDigestWeekConfig &weekConfig, const TString &prefix, const TString &regexStr, const TString &comment, TString &oldTable, TString &newTable);
bool IsDigestReportProcessed(NYT::IClientBasePtr clientSearch, const TDigestWeekConfig &weekConfig);
int TaskBuildReport(int, const char **);

} //namespace NWebmaster
