#pragma once

#include <util/generic/singleton.h>

#include <wmconsole/version3/library/env/yt.h>
#include <wmconsole/version3/searchqueries-mr/conf/yt.h>

namespace NWebmaster {

static const char* F_URL = "Url";
static const char* F_LAST_ACCESS = "LastAccess";
static const char* F_REDIR_TARGET = "RedirTarget";
static const char* F_FAVICON_LAST_ACCESS = "FaviconLastAccess";
static const char* F_ADD_TIME = "AddTime";
static const char* F_FAVICON_HTTP_CODE = "FaviconHTTPCode";
static const char* F_MIME_TYPE = "MimeType";
static const char* F_FILTER_CODE = "FilterCode";
static const char* F_SOURCE_NAME = "SourceName";
static const char* F_HOST_TABLE = "HostTable";
static const char* F_HTTP_CODE = "HTTPCode";

struct TConfig {
    static const TConfig &CInstance() {
        return *Singleton<TConfig>();
    }

    TConfig() {
        const TProdYTEnvironment prodEnv;
        MR_SERVER                            = "arnold";
        MR_SERVER_HOST                       = "arnold.yt.yandex.net";

        TABLE_LEMUR_ROOT                     = NYTUtils::JoinPath(prodEnv.TABLE_ENV_ROOT, "lemur/BadFaviconsData");
        TABLE_SAMOVAR_ROOT                   = NYTUtils::JoinPath(prodEnv.TABLE_ENV_ROOT, "samovar/FaviconBadExport");
        TABLE_FAVICONS_ROOT                  = "//home/favicon-robot/Base";
        TABLE_SUPPORT_DATA                   = NYTUtils::JoinPath(TABLE_FAVICONS_ROOT, "_prod/support_table");
        TABLE_ENRICHED                       = NYTUtils::JoinPath(TABLE_FAVICONS_ROOT, "_prod/selected");
        TABLE_ROOT                           = NYTUtils::JoinPath(prodEnv.TABLE_ENV_ROOT, "favicons");
        TABLE_WEBMASTER_HOSTS                = NYTUtils::JoinPath(prodEnv.TABLE_ENV_ROOT, "export/webmaster-hosts");
        TABLE_LEMUR_SNAPSHOT                 = NYTUtils::JoinPath(TABLE_ROOT, "lemur-snapshot");
        TABLE_SAMOVAR_SNAPSHOT               = NYTUtils::JoinPath(TABLE_ROOT, "samovar-snapshot");
        TABLE_HOST_FAVICONS                  = NYTUtils::JoinPath(TABLE_ROOT, "host-favicons");
        TABLE_HOST_FAVICONS2                 = NYTUtils::JoinPath(TABLE_ROOT, "host-favicons2");
        TABLE_PREV_HOST_FAVICONS             = NYTUtils::JoinPath(TABLE_ROOT, "prev-host-favicons");
        TABLE_CHANGES_ROOT                   = NYTUtils::JoinPath(TABLE_ROOT, "changes");

        ATTR_LAST_PROCESSED_TABLE            = "last_processed_table";
        ATTR_BIG_FAVICON_EXP                 = "big_favicon_exp";
        ATTR_PROD_TAG                        = "tags/prod";
    }

public:
    TString MR_SERVER;
    TString MR_SERVER_HOST;
    TString TABLE_LEMUR_ROOT;
    TString TABLE_SAMOVAR_ROOT;
    TString TABLE_FAVICONS_ROOT;
    TString TABLE_SUPPORT_DATA;
    TString TABLE_ENRICHED;
    TString TABLE_ROOT;
    TString TABLE_LEMUR_SNAPSHOT;
    TString TABLE_SAMOVAR_SNAPSHOT;
    TString TABLE_HOST_FAVICONS;
    TString TABLE_HOST_FAVICONS2;
    TString TABLE_PREV_HOST_FAVICONS;
    TString TABLE_WEBMASTER_HOSTS;
    TString TABLE_HOST_PROBLEMS;
    TString TABLE_CHANGES_ROOT;
    TString ATTR_LAST_PROCESSED_TABLE;
    TString ATTR_BIG_FAVICON_EXP;
    TString ATTR_PROD_TAG;
};

} //namespace NWebmaster
