#pragma once

#include <util/generic/singleton.h>
#include <util/generic/string.h>

#include <wmconsole/version3/library/conf/yt.h>
#include <wmconsole/version3/library/env/yt.h>
#include <wmconsole/version3/wmcutil/config_base.h>

namespace NWebmaster {
namespace NFeeds {

struct TConfig {
    static const TConfig &CInstance() {
        return *Singleton<TConfig>();
    }

    TConfig() {
        TCustomYTEnvironment::Instance().Init("prod");

        MR_TURBO_SERVER_HOST                    = "hahn.yt.yandex.net";
        TABLE_SOURCE_DATACAMP                   = "//home/market/production/indexer/datacamp";
        TABLE_SOURCE_LOGS_ROOT                  = "//home/turborss/production/offers/logs";
        TABLE_SOURCE_TURBO_LOGS_ROOT            = "//home/turborss/production.yml/logs";
        TABLE_SOURCE_VERTICAL_SHARE_HOSTS       = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_ROOT, "export/feeds/vertical_share/feeds_info");
        TABLE_SOURCE_SERPDATA_BY_FEED_LOGS_ROOT = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_ROOT, "import/feeds/unisearch/serpdata/by_feed");
        TABLE_SOURCE_SERPDATA_TOTAL_LOGS_ROOT   = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_ROOT, "import/feeds/unisearch/serpdata/total");
        TABLE_EXPORT_NATIVE_FEEDS               = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_ROOT, "export/feeds/native_feeds");
        TABLE_SOURCE_OFFER_BASE                 = "//home/turborss/production/offers/offer_base_full";
        TABLE_DESTINATION_ROOT                  = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_ROOT, "feeds");
        TABLE_SOURCE_VERTICAL_SHARE_OFFER_BANS  = NYTUtils::JoinPath(TABLE_DESTINATION_ROOT, "offer_bans/vertical_share_bans");
        TABLE_SOURCE_OFFER_BANS_JOINED          = NYTUtils::JoinPath(TABLE_DESTINATION_ROOT, "offer_bans/offer_bans_joined");
        TABLE_FEEDS_HISTORY                     = NYTUtils::JoinPath(TABLE_DESTINATION_ROOT, "offers/history");
        TABLE_FEEDS_LAST_STATE                  = NYTUtils::JoinPath(TABLE_DESTINATION_ROOT, "offers/last-state");
        TABLE_FEEDS_ARCHIVE                     = NYTUtils::JoinPath(TABLE_DESTINATION_ROOT, "offers/archive");
        TABLE_SERPDATA_HISTORY                  = NYTUtils::JoinPath(TABLE_DESTINATION_ROOT, "serpdata/history");
        TABLE_SERPDATA_LAST_STATE               = NYTUtils::JoinPath(TABLE_DESTINATION_ROOT, "serpdata/last-state");
        TABLE_SERPDATA_ARCHIVE                  = NYTUtils::JoinPath(TABLE_DESTINATION_ROOT, "serpdata/archive");
        TABLE_DATACAMP_SERVICE_OFFERS           = NYTUtils::JoinPath(TABLE_SOURCE_DATACAMP, "united/service_offers");
        TABLE_ABO_OFFER_BANS                    = "//home/market-quality-control/unisearch/prod/banned_offers";

    }

public:
    TString MR_TURBO_SERVER_HOST;
    TString TABLE_SOURCE_LOGS_ROOT;
    TString TABLE_SOURCE_TURBO_LOGS_ROOT;
    TString TABLE_SOURCE_SERPDATA_BY_FEED_LOGS_ROOT;
    TString TABLE_SOURCE_SERPDATA_TOTAL_LOGS_ROOT;
    TString TABLE_EXPORT_NATIVE_FEEDS;
    TString TABLE_SOURCE_OFFER_BASE;
    TString TABLE_DESTINATION_ROOT;
    TString TABLE_FEEDS_HISTORY;
    TString TABLE_FEEDS_LAST_STATE;
    TString TABLE_FEEDS_ARCHIVE;
    TString TABLE_SERPDATA_HISTORY;
    TString TABLE_SERPDATA_LAST_STATE;
    TString TABLE_SERPDATA_ARCHIVE;
    TString TABLE_DATACAMP_SERVICE_OFFERS;
    TString TABLE_SOURCE_DATACAMP;
    TString TABLE_SOURCE_VERTICAL_SHARE_HOSTS;
    TString TABLE_SOURCE_VERTICAL_SHARE_OFFER_BANS;
    TString TABLE_SOURCE_OFFER_BANS_JOINED;
    TString TABLE_ABO_OFFER_BANS;

};

} //namespace NFeeds
} //namespace NWebmaster
