
#include <library/cpp/getopt/modchooser.h>

#include <mapreduce/yt/interface/client.h>

#include "process_offer_logs.h"
#include "process_offer_bans.h"

int main(int argc, const char **argv) {
    NYT::Initialize(argc, argv);
    using namespace NWebmaster;
    using namespace NWebmaster::NFeeds;

    TModChooser modChooser;
    modChooser.AddMode("ProcessOfferLogs", ProcessOfferLogs, "ProcessOfferLogs");
    modChooser.AddMode("ProcessSerpdataLogs", ProcessSerpdataLogs, "ProcessSerpdataLogs");
    modChooser.AddMode("ProcessOfferBans", ProcessOfferBans, "ProcessOfferBans");

    return modChooser.Run(argc, argv);
}

