#pragma once

#include <util/generic/singleton.h>
#include <util/generic/string.h>
#include <util/string/subst.h>

#include <wmconsole/version3/library/conf/yt.h>

#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {
namespace NCheckurl {

struct TConfig {
    static TConfig &Instance() {
        return *Singleton<TConfig>();
    }

    static const TConfig &CInstance() {
        return Instance();
    }

    TConfig() {
        MR_SERVER_HOST                              = "arnold.yt.yandex.net";

        MONITOR_PERFORMANCE_SUFFIX                  = "production";

        TABLE_ROOT                                  = TCommonYTConfig::CInstance().TABLE_ROOT;
        TABLE_EXPORT_ROOT                           = TCommonYTConfig::CInstance().TABLE_EXPORT_ROOT;
        TABLE_USER_ROOT                             = TCommonYTConfig::CInstance().TABLE_USER_ROOT;
        TABLE_TEMP_ROOT                             = NYTUtils::JoinPath(TABLE_ROOT, "tmp");

        TABLE_SOURCE_WEBMASTER_HOSTS                = TCommonYTConfig::CInstance().TABLE_SOURCE_WEBMASTER_HOSTS;

        TABLE_CHECKURL_ROOT                         = NYTUtils::JoinPath(TABLE_ROOT, "checkurl");
        TABLE_CHECKURL_INCOME_PREFIX                = NYTUtils::JoinPath(TABLE_CHECKURL_ROOT, "income");
        TABLE_CHECKURL_OUTCOME_PREFIX               = NYTUtils::JoinPath(TABLE_CHECKURL_ROOT, "outcome");
        TABLE_CHECKURL_OUTCOME_FOR_MERGE_PREFIX     = NYTUtils::JoinPath(TABLE_CHECKURL_ROOT, "outcome-for-merge");
        TABLE_CHECKURL_OUTCOME_MERGED               = NYTUtils::JoinPath(TABLE_CHECKURL_ROOT, "outcome-merged");
    }

public:
    TString MR_SERVER_HOST;

    TString TABLE_ROOT;
    TString TABLE_EXPORT_ROOT;
    TString TABLE_TEMP_ROOT;
    TString TABLE_USER_ROOT;

    TString TABLE_SOURCE_WEBMASTER_HOSTS;

    TString TABLE_CHECKURL_ROOT;
    TString TABLE_CHECKURL_INCOME_PREFIX;
    TString TABLE_CHECKURL_OUTCOME_PREFIX;
    TString TABLE_CHECKURL_OUTCOME_FOR_MERGE_PREFIX;
    TString TABLE_CHECKURL_OUTCOME_MERGED;

    TString MONITOR_PERFORMANCE_SUFFIX;
};

} //namespace NCheckurl
} //namespace NWebmaster
