#include "monitor.h"

namespace NWebmaster {

template<class T>
void MonitorPushLabel(const TString &suffix, const TString &service, const TString &label, T value) {
    TSolomonPushBackend pushBackend("webmaster", "webmaster_performance_" + suffix);
    TMonitoringAgent<TSolomonPushBackend> agent(pushBackend);

    agent
        .Next(label, value)
        .GlobalService(service)
        .Commit();
}

template<class T>
void MonitorPushQualityLabel(const TString &suffix, const TString &label, T value) {
    MonitorPushLabel(suffix, "webmaster_quality", label, value);
}

void MonitorPushCheckurlProcessed(const TString &suffix, size_t value) {
    MonitorPushQualityLabel(suffix, "CheckUrl_UrlsProcessed", value);
}

void MonitorPushCheckurlSpamness(const TString &suffix, double value) {
    MonitorPushQualityLabel(suffix, "CheckUrl_HostnamesSpamness", value);
}

} //namespace NWebmaster
