#pragma once

#include <wmconsole/version3/wmcutil/yt/yt_utils.h>
#include <wmconsole/version3/library/jupiter/jupiter.h>

#include "fields.h"

namespace NWebmaster {

inline NYT::TTableSchema CreateCheckUrlOutcomeSchema(NYT::IClientBasePtr tx) {
    NYT::TTableSchema schema = NYTUtils::GetTableSchema(tx, GetJupiterAcceptanceInProdTable(tx));
    schema.AddColumn(NYT::TColumnSchema().Name(F_FOUND_BASE).Type(NYT::VT_BOOLEAN));
    schema.AddColumn(NYT::TColumnSchema().Name(F_FOUND_SPREAD).Type(NYT::VT_BOOLEAN));
    schema.AddColumn(NYT::TColumnSchema().Name(F_JUPITER_TIMESTAMP).Type(NYT::VT_UINT64));
    schema.AddColumn(NYT::TColumnSchema().Name(F_SPREAD_LAST_ACCESS).Type(NYT::VT_UINT64));
    schema.AddColumn(NYT::TColumnSchema().Name(F_SPREAD_HTTP_CODE).Type(NYT::VT_UINT64));
    schema.AddColumn(NYT::TColumnSchema().Name(F_SPREAD_MIME_TYPE).Type(NYT::VT_UINT64));
    schema.AddColumn(NYT::TColumnSchema().Name(F_TITLE).Type(NYT::VT_STRING));
    schema.AddColumn(NYT::TColumnSchema().Name(F_DESCRIPTION).Type(NYT::VT_STRING));
    schema.AddColumn(NYT::TColumnSchema().Name(F_URL).Type(NYT::VT_STRING));
    schema.AddColumn(NYT::TColumnSchema().Name(F_REQUEST_ID).Type(NYT::VT_ANY));
    schema.AddColumn(NYT::TColumnSchema().Name(F_IS_TURBO_PAGE).Type(NYT::VT_BOOLEAN));
    return schema;
}

inline NYT::TTableSchema CreateCheckUrlMergeSchema(const NYT::TTableSchema &updateSchema) {
    NYT::TTableSchema mergeSchema = NYTUtils::DropSortOrder(updateSchema);
    mergeSchema.AddColumn(NYT::TColumnSchema().Name(F_TABLE_TIMESTAMP).Type(NYT::VT_UINT64));
    return mergeSchema;
}

} //namespace NWebmaster
