YQL="yql --syntax-version=1"
ENV="prod"
CHECKURL="indexing/checkurl/checkurl -E ${ENV}"
CRAWLER="indexing/crawler/crawler -E ${ENV}"
HOSTINFO="indexing/hostinfo/hostinfo -E ${ENV}"
IMPORTANT_URLS="indexing/important_urls/important_urls -E ${ENV}"
ROBOTS="indexing/robots/robots -E ${ENV}"
SITETREE="indexing/sitetree/sitetree -E ${ENV}"
DISALLOWED_URLS="indexing/robots/disallowed_urls/disallowed_urls -E ${ENV}"

_scenario() {
    MAIN    indexing_host_status:
    MAIN    indexing_host_statistics:
    MAIN    indexing_host_regions:
    MAIN    indexing_host_problems:         indexing_host_status indexing_host_statistics indexing_host_regions restart_on_success="10 * * * *" retry_on_failure="3 */8 * * *" mailto=wmconsole-dev-alert@yandex-team.ru
    MAIN    indexing_checkurl_update:       restart_on_success="* * * * *" retry_on_failure="7 */6 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    indexing_checkurl_merge:
    MAIN    indexing_crawler_update_samples:
    MAIN    indexing_crawler_compact_events:    indexing_crawler_update_samples
    MAIN    indexing_crawler_compact_recent:    indexing_crawler_update_samples
    MAIN    indexing_crawler_update:            indexing_crawler_compact_events indexing_crawler_compact_recent restart_on_success="20 */3 * * *" retry_on_failure="8 */8 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    indexing_mercury_important_urls:    restart_on_success="11 */3 * * *" retry_on_failure="5 */5 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,ishalaru@yandex-team.ru
    MAIN    indexing_important_urls_update:     restart_on_success="25 */2 * * *" retry_on_failure="6 */8 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    indexing_important_urls_merge:
    MAIN    indexing_important_urls_history:    indexing_checkurl_merge indexing_important_urls_merge restart_on_success="30 */6 * * *" retry_on_failure="6 */8 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    indexing_robots_history:        restart_on_success="15 1 * * *" retry_on_failure="4 */12 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    indexing_robots_parse:          restart_on_success="20 2 * * *" retry_on_failure="5 */12 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    indexing_sitetree_monsters:     restart_on_success="0 * * * 1" retry_on_failure="2 */8 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    indexing_sitetree_cleanup:
    MAIN    indexing_sitetree_basediff:     indexing_sitetree_cleanup
    MAIN    indexing_sitetree_sitetree:     indexing_sitetree_basediff
    MAIN    indexing_sitetree_archive:      indexing_sitetree_sitetree restart_on_success="0 * * * *" retry_on_failure="2 */8 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    indexing_sitetree_testing:      restart_on_success="44 * * * *" retry_on_failure="44 * * * *"
    MAIN    indexing_subdomains:            restart_on_success="30 * * * *" retry_on_failure="2 */8 * * *"
    MAIN    indexing_robots_clean_param:    restart_on_success="30 * * * *" retry_on_failure="30 * * * *" mailto=wmconsole-dev-alert@yandex-team.ru
    MAIN    indexing_sitetree_fresh:        restart_on_success="11 */3 * * *" retry_on_failure="5 */5 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,ishalaru@yandex-team.ru
    MAIN    indexing_disallowed_urls:       restart_on_success="55 */8 * * *" retry_on_failure="55 */12 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
}

function indexing_checkurl_update {
    ${CHECKURL} Update
}

function indexing_checkurl_merge {
    ${CHECKURL} Merge
}

function indexing_crawler_update_samples {
    ${CRAWLER} UpdateSamples
}

function indexing_crawler_compact_events {
    ${CRAWLER} CompactEvents
}

function indexing_crawler_compact_recent {
    ${CRAWLER} CompactRecent
}

function indexing_crawler_update {
    echo
}

function indexing_host_status {
    ${HOSTINFO} HostStatus
}

function indexing_host_statistics {
    ${HOSTINFO} HostStatistics
}

function indexing_host_regions {
    ${HOSTINFO} HostRegions
}

function indexing_host_problems {
    ${HOSTINFO} HostProblems
}

function indexing_important_urls_update {
    ${IMPORTANT_URLS} Update
}

function indexing_important_urls_merge {
    ${IMPORTANT_URLS} Merge
}

function indexing_important_urls_history {
    ${IMPORTANT_URLS} History
}

function indexing_robots_parse {
    ${ROBOTS}
}

function indexing_robots_history {
    ${YQL} -i indexing/robots/history.sql
}

function indexing_sitetree_archive {
    ${SITETREE} Archive
}

function indexing_sitetree_cleanup {
    ${SITETREE} Cleanup
}

function indexing_sitetree_basediff {
    ${SITETREE} BaseDiff
}

function indexing_sitetree_monsters {
    ${SITETREE} Monsters
}

function indexing_sitetree_sitetree {
    ${SITETREE} Sitetree
}

function indexing_sitetree_testing {
    ${SITETREE} Testing
}

function indexing_subdomains {
    ${YQL} -i indexing/subdomains/subdomains.sql
}

function indexing_robots_clean_param {
    ${YQL} -i indexing/robots/insignificant_cgi_parameters.sql
}

function indexing_mercury_important_urls {
    ${YQL} -i indexing/robots/sitetree_mercury_fresh.sql
}

function indexing_sitetree_fresh {
    ${YQL} -i indexing/robots/sitetree_fresh.sql
}

function indexing_disallowed_urls {
    ${DISALLOWED_URLS} GetDisallowedUrls
}
