#pragma once

#include <util/generic/singleton.h>
#include <util/generic/string.h>
#include <util/string/subst.h>

#include <wmconsole/version3/library/conf/yt.h>

#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {

struct TConfig {
    static TConfig &Instance() {
        return *Singleton<TConfig>();
    }

    static const TConfig &CInstance() {
        return Instance();
    }

    TConfig() {
        MR_SERVER_HOST                              = "arnold.yt.yandex.net";
        MR_SERVER_HOST_KWYT                         = "arnold.yt.yandex.net";

        TABLE_ROOT                                  = TCommonYTConfig::CInstance().TABLE_ROOT;
        TABLE_EXPORT_ROOT                           = TCommonYTConfig::CInstance().TABLE_EXPORT_ROOT;
        TABLE_USER_ROOT                             = TCommonYTConfig::CInstance().TABLE_USER_ROOT;
        TABLE_TEMP_ROOT                             = NYTUtils::JoinPath(TABLE_ROOT, "tmp");

        TABLE_SOURCE_ROBOTS                         = "//home/kwyt/hosts/robots";

        TABLE_SOURCE_WEBMASTER_HOSTS                = TCommonYTConfig::CInstance().TABLE_SOURCE_WEBMASTER_HOSTS;

        TABLE_SITETREE_ROOT                         = NYTUtils::JoinPath(TABLE_ROOT, "sitetree");

        TABLE_CRAWLER_ROOT                          = NYTUtils::JoinPath(TABLE_ROOT, "crawler");
        TABLE_CRAWLER_PROCESSED_LOG                 = NYTUtils::JoinPath(TABLE_CRAWLER_ROOT, "log_processed_spread");
        TABLE_CRAWLER_DAILY_COUNTERS_EVENT          = NYTUtils::JoinPath(TABLE_CRAWLER_ROOT, "counters/daily/events");
        TABLE_CRAWLER_DAILY_COUNTERS_HTTP           = NYTUtils::JoinPath(TABLE_CRAWLER_ROOT, "counters/daily/http_codes");
        TABLE_CRAWLER_RAW_COUNTERS_EVENT            = NYTUtils::JoinPath(TABLE_CRAWLER_ROOT, "counters/raw/events");
        TABLE_CRAWLER_RAW_COUNTERS_HTTP             = NYTUtils::JoinPath(TABLE_CRAWLER_ROOT, "counters/raw/http_codes");
        TABLE_CRAWLER_RAW_COUNTERS_SPREAD           = NYTUtils::JoinPath(TABLE_CRAWLER_ROOT, "counters/raw/spread");
        TABLE_CRAWLER_ROBOTS_TXT                    = NYTUtils::JoinPath(TABLE_CRAWLER_ROOT, "robots");
        TABLE_CRAWLER_SOURCE_SITETREE               = NYTUtils::JoinPath(TABLE_CRAWLER_ROOT, "sitetree");
        TABLE_CRAWLER_TAIL_SAMPLES_EVENT            = NYTUtils::JoinPath(TABLE_CRAWLER_ROOT, "samples/events/tail");
        TABLE_CRAWLER_TAIL_SAMPLES_RECENT           = NYTUtils::JoinPath(TABLE_CRAWLER_ROOT, "samples/recent/tail");
        TABLE_CRAWLER_WEEKLY_SAMPLES_EVENT          = NYTUtils::JoinPath(TABLE_CRAWLER_ROOT, "samples/events/weekly");
        TABLE_CRAWLER_WEEKLY_SAMPLES_RECENT         = NYTUtils::JoinPath(TABLE_CRAWLER_ROOT, "samples/recent/weekly");

        MONITOR_PERFORMANCE_SUFFIX                  = "production";
    }

public:
    TString MR_SERVER_HOST;
    TString MR_SERVER_HOST_KWYT;

    TString TABLE_ROOT;
    TString TABLE_EXPORT_ROOT;
    TString TABLE_TEMP_ROOT;
    TString TABLE_USER_ROOT;

    TString TABLE_SOURCE_ROBOTS;
    TString TABLE_SOURCE_WEBMASTER_HOSTS;
    size_t TABLE_SOURCE_WEBMASTER_HOSTS_ROW_COUNT   = 4000000;

    TString TABLE_SITETREE_ROOT;

    TString TABLE_CRAWLER_ROOT;
    TString TABLE_CRAWLER_DAILY_COUNTERS_EVENT;
    TString TABLE_CRAWLER_DAILY_COUNTERS_HTTP;
    TString TABLE_CRAWLER_PROCESSED_LOG;
    TString TABLE_CRAWLER_RAW_COUNTERS_EVENT;
    TString TABLE_CRAWLER_RAW_COUNTERS_HTTP;
    TString TABLE_CRAWLER_RAW_COUNTERS_SPREAD;
    TString TABLE_CRAWLER_ROBOTS_TXT;
    TString TABLE_CRAWLER_SOURCE_SITETREE;
    TString TABLE_CRAWLER_TAIL_SAMPLES_EVENT;
    TString TABLE_CRAWLER_TAIL_SAMPLES_RECENT;
    TString TABLE_CRAWLER_WEEKLY_SAMPLES_EVENT;
    TString TABLE_CRAWLER_WEEKLY_SAMPLES_RECENT;

    TString MONITOR_PERFORMANCE_SUFFIX;
};

} //namespace NWebmaster
