#pragma once

#include <util/generic/singleton.h>
#include <util/generic/string.h>
#include <util/string/subst.h>

#include <wmconsole/version3/library/conf/yt.h>

#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {
namespace NHostInfo {

struct TAttrName {
    //static constexpr char const AcceptanceSource[]  = "acceptance_table";
    static constexpr char const Source[]            = "source_table";
};

struct TConfig {
    static TConfig &Instance() {
        return *Singleton<TConfig>();
    }

    static const TConfig &CInstance() {
        return Instance();
    }

    TConfig() {
        const auto &ccfg = TCommonYTConfig::CInstance();
        MR_SERVER_HOST_JUPITER                      = ccfg.MR_SERVER_HOST_JUPITER;
        MR_SERVER_HOST_KWYT                         = ccfg.MR_SERVER_HOST_KWYT;
        MR_SERVER_HOST_ALTAY                        = "hahn.yt.yandex.net";

        TABLE_TEMP_ROOT                             = ccfg.TABLE_TEMP_ROOT;
        TABLE_SOURCE_HOST_STATUS                    = "//home/kwyt/hosts/status";
        TABLE_SOURCE_WEBMASTER_HOSTS                = ccfg.TABLE_SOURCE_WEBMASTER_HOSTS;

        TABLE_EXPORT_ROOT                           = ccfg.GetStagePath(ccfg.TABLE_EXPORT_ROOT);
        TABLE_EXPORT_DISALLOWED_URLS_ROOT           = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "disallowed_urls_alert");
        TABLE_EXPORT_HOST_STATUS                    = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "host_status_v2");
        TABLE_EXPORT_HOSTINFO_ROOT                  = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "hostinfo");
        TABLE_EXPORT_HOST_STATISTICS                = NYTUtils::JoinPath(TABLE_EXPORT_HOSTINFO_ROOT, "host_statistics");

        FILE_SOURCE_DICTIONARY_REGIONS              = "//home/sprav/altay/prod/export/geoadresa.flt";
        TABLE_SOURCE_CREATED_COMPANY_PROFILES       = "//home/altay-dev/marvelstas/webmaster/webmaster_hosts_with_company_with_not_active_owner.uniq_hosts";
        TABLE_SOURCE_WEBMASTER_REGIONS              = NYTUtils::JoinPath(ccfg.TABLE_EXPORT_ROOT, "geoclassifier/webmaster_geo.flt");
        TABLE_EXPORT_HOST_REGIONS                   = NYTUtils::JoinPath(TABLE_EXPORT_HOSTINFO_ROOT, "host_regions");

        TABLE_EXPORT_HOST_PROBLEMS                  = NYTUtils::JoinPath(TABLE_EXPORT_HOSTINFO_ROOT, "host_problems");
        TABLE_EXPORT_HOST_PROBLEMS_CHANGES          = NYTUtils::JoinPath(TABLE_EXPORT_HOSTINFO_ROOT, "changes");
        TABLE_TEMP_MIRRORS_REVERSED                 = "//tmp/webmaster/mirrors-reversed";
        TABLE_EXPORT_HOST_FACE_PROBLEM              = NYTUtils::JoinPath(TABLE_EXPORT_HOSTINFO_ROOT, "face.problem");

        TABLE_EXPORT_DISALLOWED_URLS_FILTERED       = NYTUtils::JoinPath(TABLE_EXPORT_DISALLOWED_URLS_ROOT, "filtered_urls");

        MONITOR_PERFORMANCE_SUFFIX                  = "production";
    }

public:
    TString MR_SERVER_HOST_JUPITER;
    TString MR_SERVER_HOST_KWYT;
    TString MR_SERVER_HOST_ALTAY;

    TString TABLE_TEMP_ROOT;

    TString TABLE_SOURCE_HOST_STATUS;
    TString TABLE_SOURCE_WEBMASTER_HOSTS;

    TString TABLE_EXPORT_ROOT;
    TString TABLE_EXPORT_DISALLOWED_URLS_ROOT;
    TString TABLE_EXPORT_HOST_STATUS;
    TString TABLE_EXPORT_HOSTINFO_ROOT;
    TString TABLE_EXPORT_HOST_STATISTICS;

    TString FILE_SOURCE_DICTIONARY_REGIONS;
    TString TABLE_SOURCE_CREATED_COMPANY_PROFILES;
    TString TABLE_SOURCE_WEBMASTER_REGIONS;
    TString TABLE_EXPORT_HOST_REGIONS;

    TString TABLE_EXPORT_HOST_PROBLEMS;
    TString TABLE_EXPORT_HOST_PROBLEMS_CHANGES;
    TString TABLE_TEMP_MIRRORS_REVERSED;
    TString TABLE_EXPORT_HOST_FACE_PROBLEM;

    TString TABLE_EXPORT_DISALLOWED_URLS_FILTERED;

    TString MONITOR_PERFORMANCE_SUFFIX;
};

} //namespace NHostInfo
} //namespace NWebmaster
