#pragma once

#include <util/generic/singleton.h>
#include <util/generic/string.h>
#include <util/string/subst.h>

#include <wmconsole/version3/library/conf/yt.h>

#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {
namespace NImportantUrls {

struct TAttrName {
    static constexpr char const Imported[]              = "imported";
    static constexpr char const Suspicious[]            = "suspicious";
    static constexpr char const SuspiciousParams[]      = "suspicious_params";
    static constexpr char const ProcessedTimestamp[]    = "processed_timestamp";
};

struct TConfig {
    static TConfig &Instance() {
        return *Singleton<TConfig>();
    }

    static const TConfig &CInstance() {
        return Instance();
    }

    TConfig() {
        MR_SERVER_HOST                              = "arnold.yt.yandex.net";

        TABLE_ROOT                                  = TCommonYTConfig::CInstance().TABLE_ROOT;
        TABLE_EXPORT_ROOT                           = TCommonYTConfig::CInstance().TABLE_EXPORT_ROOT;
        TABLE_USER_ROOT                             = TCommonYTConfig::CInstance().TABLE_USER_ROOT;
        TABLE_TEMP_ROOT                             = NYTUtils::JoinPath(TABLE_ROOT, "tmp");

        TABLE_SOURCE_WEBMASTER_HOSTS                = TCommonYTConfig::CInstance().TABLE_SOURCE_WEBMASTER_HOSTS;

        TABLE_IMPORTANT_URLS_ROOT                   = NYTUtils::JoinPath(TABLE_ROOT, "important_urls");
        TABLE_IMPORTANT_URLS_SNAPSHOT               = NYTUtils::JoinPath(TABLE_IMPORTANT_URLS_ROOT, "snapshot");
        TABLE_IMPORTANT_URLS_UPDATES                = NYTUtils::JoinPath(TABLE_IMPORTANT_URLS_ROOT, "updates");
        TABLE_IMPORTANT_URLS_SOURCE_URLS_RAW        = NYTUtils::JoinPath(TABLE_IMPORTANT_URLS_ROOT, "important_urls");
        TABLE_IMPORTANT_URLS_SOURCE_URLS_PREPARED   = NYTUtils::JoinPath(TABLE_IMPORTANT_URLS_ROOT, "source_urls");
        TABLE_IMPORTANT_URLS_SOURCE_JUPITER         = NYTUtils::JoinPath(TABLE_IMPORTANT_URLS_ROOT, "source_jupiter");
        TABLE_IMPORTANT_URLS_SOURCE_SPREAD          = NYTUtils::JoinPath(TABLE_IMPORTANT_URLS_ROOT, "source_spread");
        TABLE_IMPORTANT_URLS_SOURCE_CALLISTO        = NYTUtils::JoinPath(TABLE_IMPORTANT_URLS_ROOT, "source_callisto");
        TABLE_IMPORTANT_URLS_SOURCE_CONTENT         = NYTUtils::JoinPath(TABLE_IMPORTANT_URLS_ROOT, "source_content");
        TABLE_IMPORTANT_URLS_MERGED                 = NYTUtils::JoinPath(TABLE_IMPORTANT_URLS_ROOT, "updates-merged");
        TABLE_IMPORTANT_URLS_FLAG                   = NYTUtils::JoinPath(TABLE_IMPORTANT_URLS_ROOT, "flag-table-wmc-5446");
        TABLE_IMPORTANT_URLS_HISTORY                = NYTUtils::JoinPath(TABLE_IMPORTANT_URLS_ROOT, "history");
        TABLE_IMPORTANT_URLS_LAST_STATE             = NYTUtils::JoinPath(TABLE_IMPORTANT_URLS_ROOT, "last-state");
        TABLE_IMPORTANT_URLS_CHANGES                = NYTUtils::JoinPath(TABLE_IMPORTANT_URLS_ROOT, "changes");

        MONITOR_PERFORMANCE_SUFFIX                  = "production";

        TABLE_SOURCE_SEARCH_BASES                   = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "searchbases");
        TABLE_USER_NOTIFICATION_SETTINGS            = NYTUtils::JoinPath(TABLE_USER_ROOT, "user-notification-settings/user-notification-channel-settings");
    }

public:
    static bool IgnoreChecks;

public:
    TString MR_SERVER_HOST;

    TString TABLE_ROOT;
    TString TABLE_EXPORT_ROOT;
    TString TABLE_TEMP_ROOT;
    TString TABLE_USER_ROOT;

    TString TABLE_SOURCE_WEBMASTER_HOSTS;

    TString TABLE_IMPORTANT_URLS_ROOT;
    TString TABLE_IMPORTANT_URLS_SNAPSHOT;
    TString TABLE_IMPORTANT_URLS_UPDATES;
    TString TABLE_IMPORTANT_URLS_SOURCE_URLS_RAW;
    TString TABLE_IMPORTANT_URLS_SOURCE_URLS_PREPARED;
    TString TABLE_IMPORTANT_URLS_SOURCE_JUPITER;
    TString TABLE_IMPORTANT_URLS_SOURCE_SPREAD;
    TString TABLE_IMPORTANT_URLS_SOURCE_CALLISTO;
    TString TABLE_IMPORTANT_URLS_SOURCE_CONTENT;
    TString TABLE_IMPORTANT_URLS_MERGED;
    TString TABLE_IMPORTANT_URLS_FLAG;
    TString TABLE_IMPORTANT_URLS_HISTORY;
    TString TABLE_IMPORTANT_URLS_LAST_STATE;
    TString TABLE_IMPORTANT_URLS_CHANGES;

    TString MONITOR_PERFORMANCE_SUFFIX;

    TString TABLE_SOURCE_SEARCH_BASES;
    TString TABLE_USER_NOTIFICATION_SETTINGS;

    const size_t MAX_MERGED_TABLES  = 100;
};

} //namespace NImportantUrls
} //namespace NWebmaster
