#pragma once

#include <util/generic/hash_set.h>

#include <wmconsole/version3/wmcutil/string.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

#include "notification_types.h"

namespace NWebmaster {
namespace NImportantUrls {

constexpr const char *F_DESCRIPTION             = "Description";
constexpr const char *F_FOUND_BASE              = "FoundBase";
constexpr const char *F_FOUND_SPREAD            = "FoundSpread";
constexpr const char *F_HOST                    = "Host";
constexpr const char *F_HTTP_CODE               = "HttpCode";
constexpr const char *F_JUPITER_TIMESTAMP       = "JupiterTimestamp";
constexpr const char *F_LAST_ACCESS             = "LastAccess";
constexpr const char *F_MIME_TYPE               = "MimeType";
constexpr const char *F_PATH                    = "Path";
constexpr const char *F_PREV_SPREAD_HTTP_CODE   = "PrevSpreadHttpCode";
constexpr const char *F_PREV_SPREAD_LAST_ACCESS = "PrevSpreadLastAccess";
constexpr const char *F_PREV_SPREAD_MIME_TYPE   = "PrevSpreadMimeType";
constexpr const char *F_SPREAD_HTTP_CODE        = "SpreadHttpCode";
constexpr const char *F_SPREAD_LAST_ACCESS      = "SpreadLastAccess";
constexpr const char *F_SPREAD_MIME_TYPE        = "SpreadMimeType";
constexpr const char *F_TITLE                   = "Title";
constexpr const char *F_URL                     = "Url";
constexpr const char *F_USER_ID                 = "UserId";
constexpr const char *F_TABLE_TIMESTAMP         = "TableTimestamp";
constexpr const char *F_COLLECTION_DATE         = "collection_date";
constexpr const char *F_SWITCH_DATE             = "switch_date";
constexpr const char *F_URL_STATUS              = "UrlStatus";
constexpr const char *F_WMC_URL_STATUS          = "WmcUrlStatus";
constexpr const char *F_REL_CANONICAL           = "RelCanonicalTarget";
constexpr const char *F_IS_SEARCHABLE           = "IsSearchable";
constexpr const char *F_USER_SETTINGS           = "UserSettings";
constexpr const char *F_IS_TURBO_PAGE           = "IsTurboPage";
// user notification settings
constexpr const char *F_US_CHANNEL_EMAIL        = "channel_email";
constexpr const char *F_US_CHANNEL_SERVICE      = "channel_service";
constexpr const char *F_US_CHANNEL_SUP          = "channel_sup";
constexpr const char *F_US_HOST_ID              = "host_id";
constexpr const char *F_US_USER_ID              = "user_id";
constexpr const char *F_US_LOGIN                = "login";
constexpr const char *F_US_FIO                  = "fio";
constexpr const char *F_US_EMAIL                = "email";
constexpr const char *F_US_NOTIFICATION_TYPE    = "notification_type";
constexpr const char *F_US_LANGUAGE             = "language";
// changes
constexpr const char *F_CHANGES                 = "Changes";
constexpr const char *F_CURRENT                 = "Current";
constexpr const char *F_PREVIOUS                = "Previous";

constexpr const char *CHANGED_PREFIX            = "_Changed_";

inline const THashSet<TString> & JUPITER_FIELDS() {
    const static THashSet<TString> _JUPITER_FIELDS = {
        "AddTime",
        "BeautyUrl",
        F_HOST,
        F_HTTP_CODE,
        "IsFake",
        "IsIndexed",
        F_IS_SEARCHABLE,
        F_LAST_ACCESS,
        "MainHost",
        "MainMirrorHost",
        "MainPath",
        F_MIME_TYPE,
        F_PATH,
        "RedirTarget",
        F_REL_CANONICAL,
        F_URL_STATUS,
    };
    return _JUPITER_FIELDS;
}

inline const THashSet<TString> & SKIP_FIELDS() {
    const static THashSet<TString> _SKIP_FIELDS = {
        F_FOUND_SPREAD,
        F_HOST,
        F_PATH,
        F_URL,
    };

    return _SKIP_FIELDS;
}

inline const THashSet<TString> & SPREAD_FIELDS() {
    const static THashSet<TString> _SPREAD_FIELDS = {
        F_SPREAD_HTTP_CODE,
        F_SPREAD_LAST_ACCESS,
        F_SPREAD_MIME_TYPE,
    };
    return _SPREAD_FIELDS;
}

inline const TMap<TString, NYT::EValueType> &CHANGES_FIELDS() {
    const static TMap<TString, NYT::EValueType> _CHANGES_FIELDS = {
        {F_SPREAD_LAST_ACCESS, NYT::VT_UINT64},
        {F_SPREAD_HTTP_CODE,   NYT::VT_UINT64},
        {F_LAST_ACCESS,        NYT::VT_UINT64},
        {F_WMC_URL_STATUS,     NYT::VT_STRING},
        {F_TITLE,              NYT::VT_STRING},
        {F_DESCRIPTION,        NYT::VT_STRING},
        {F_REL_CANONICAL,      NYT::VT_STRING},
    };
    return _CHANGES_FIELDS;
}

inline const TMap<TString, TString> &CHANGES_TO_NOTIFICATION_TYPES() {
    const static TMap<TString, TString> _CHANGES_TO_NOTIFICATION_TYPES = {
        {F_SPREAD_LAST_ACCESS, CHANGE_INDEXING_LAST_ACCESS},
        {F_SPREAD_HTTP_CODE,   CHANGE_INDEXING_STATUS},
        {F_LAST_ACCESS,        CHANGE_SEARCH_LAST_ACCESS},
        {F_WMC_URL_STATUS,     CHANGE_SEARCH_STATUS},
        {F_TITLE,              CHANGE_TITLE},
        {F_DESCRIPTION,        CHANGE_DESCRIPTION},
        {F_REL_CANONICAL,      CHANGE_REL_CANONICAL_TARGET},
    };
    return _CHANGES_TO_NOTIFICATION_TYPES;
}

} //namespace NImportantUrls
} //namespace NWebmaster
