#include "monitor.h"

namespace NWebmaster {
namespace NImportantUrls {

template<class T>
void MonitorPushLabel(const TString &suffix, const TString &service, const TString &label, T value) {
    TSolomonPushBackend pushBackend("webmaster", "webmaster_performance_" + suffix);
    TMonitoringAgent<TSolomonPushBackend> agent(pushBackend);

    agent
        .Next(label, value)
        .GlobalService(service)
        .Commit();
}

template<class T>
void MonitorPushCountersLabel(const TString &suffix, const TString &label, T value) {
    MonitorPushLabel(suffix, "webmaster_counters", label, value);
}

template<class T>
void MonitorPushQualityLabel(const TString &suffix, const TString &label, T value) {
    MonitorPushLabel(suffix, "webmaster_quality", label, value);
}

template<class T>
void MonitorPushStateLabel(const TString &suffix, const TString &label, T value) {
    MonitorPushLabel(suffix, "webmaster_state", label, value);
}

void MonitorPushImportantUrlsProcessed(const TString &suffix, size_t value) {
    MonitorPushQualityLabel(suffix, "ImportantUrls_UrlsProcessed", value);
}

void MonitorPushImportantUrlsUpdated(const TString &suffix, size_t value) {
    MonitorPushQualityLabel(suffix, "ImportantUrls_UrlsUpdated", value);
}

void MonitorPushImportantUrlsUpdateShare(const TString &suffix, const TString &counter, float value) {
    MonitorPushQualityLabel(suffix, "ImportantUrls_Share" + counter, value);
}

} //namespace NImportantUrls
} //namespace NWebmaster
