#pragma once

#include <wmconsole/version3/library/jupiter/jupiter.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

#include "fields.h"

namespace NWebmaster {
namespace NImportantUrls {

inline NYT::TTableSchema CreatePreparedUrlsSchema() {
    NYT::TTableSchema preparedUrlsSchema;
    preparedUrlsSchema.AddColumn(NYT::TColumnSchema().Name(F_HOST).Type(NYT::VT_STRING));
    preparedUrlsSchema.AddColumn(NYT::TColumnSchema().Name(F_PATH).Type(NYT::VT_STRING));
    preparedUrlsSchema.AddColumn(NYT::TColumnSchema().Name(F_URL).Type(NYT::VT_STRING));
    preparedUrlsSchema.AddColumn(NYT::TColumnSchema().Name(F_USER_ID).Type(NYT::VT_ANY));
    preparedUrlsSchema.AddColumn(NYT::TColumnSchema().Name(F_TABLE_TIMESTAMP).Type(NYT::VT_UINT64));
    return preparedUrlsSchema;
}

inline NYT::TTableSchema CreateSnapshotSchema(NYT::IClientBasePtr client) {
    NYT::TTableSchema snapshotSchema = NYTUtils::GetTableSchema(client, GetJupiterAcceptanceTable(client));
    snapshotSchema.AddColumn(NYT::TColumnSchema().Name(F_FOUND_BASE).Type(NYT::VT_BOOLEAN));
    snapshotSchema.AddColumn(NYT::TColumnSchema().Name(F_FOUND_SPREAD).Type(NYT::VT_BOOLEAN));
    snapshotSchema.AddColumn(NYT::TColumnSchema().Name(F_JUPITER_TIMESTAMP).Type(NYT::VT_UINT64));
    snapshotSchema.AddColumn(NYT::TColumnSchema().Name(F_SPREAD_LAST_ACCESS).Type(NYT::VT_UINT64));
    snapshotSchema.AddColumn(NYT::TColumnSchema().Name(F_SPREAD_HTTP_CODE).Type(NYT::VT_UINT64));
    snapshotSchema.AddColumn(NYT::TColumnSchema().Name(F_SPREAD_MIME_TYPE).Type(NYT::VT_UINT64));
    snapshotSchema.AddColumn(NYT::TColumnSchema().Name(F_TITLE).Type(NYT::VT_STRING));
    snapshotSchema.AddColumn(NYT::TColumnSchema().Name(F_URL).Type(NYT::VT_STRING));
    snapshotSchema.AddColumn(NYT::TColumnSchema().Name(F_DESCRIPTION).Type(NYT::VT_STRING));
    snapshotSchema.AddColumn(NYT::TColumnSchema().Name(F_IS_TURBO_PAGE).Type(NYT::VT_BOOLEAN));
    return snapshotSchema;
}

inline NYT::TTableSchema CreateUpdateSchema(const NYT::TTableSchema &snapshotSchema) {
    NYT::TTableSchema updateSchema;
    updateSchema.Strict(true);
    for (const NYT::TColumnSchema &column : snapshotSchema.Columns()) {
        updateSchema.AddColumn(column);
        if (!SKIP_FIELDS().contains(column.Name())) {
            updateSchema.AddColumn(NYT::TColumnSchema().Name(CHANGED_PREFIX + column.Name()).Type(NYT::VT_BOOLEAN));
        }
    }
    updateSchema.AddColumn(NYT::TColumnSchema().Name(F_PREV_SPREAD_LAST_ACCESS).Type(NYT::VT_UINT64));
    updateSchema.AddColumn(NYT::TColumnSchema().Name(F_PREV_SPREAD_HTTP_CODE).Type(NYT::VT_UINT64));
    updateSchema.AddColumn(NYT::TColumnSchema().Name(F_PREV_SPREAD_MIME_TYPE).Type(NYT::VT_UINT64));
    return updateSchema;
}

inline NYT::TTableSchema CreateMergeSchema(const NYT::TTableSchema &updateSchema) {
    NYT::TTableSchema mergeSchema = NYTUtils::DropSortOrder(updateSchema);
    mergeSchema.AddColumn(NYT::TColumnSchema().Name(F_TABLE_TIMESTAMP).Type(NYT::VT_UINT64));
    return mergeSchema;
}

inline NYT::TTableSchema CreateHistorySchema(const NYT::TTableSchema &mergeSchema) {
    NYT::TTableSchema historySchema = NYTUtils::DropSortOrder(mergeSchema);
    historySchema.AddColumn(NYT::TColumnSchema().Name(F_WMC_URL_STATUS).Type(NYT::VT_STRING));
    const TString &changedPrefix = TString(CHANGED_PREFIX);
    historySchema.AddColumn(NYT::TColumnSchema().Name(changedPrefix + F_SPREAD_HTTP_CODE).Type(NYT::VT_BOOLEAN));
    historySchema.AddColumn(NYT::TColumnSchema().Name(changedPrefix + F_URL_STATUS).Type(NYT::VT_BOOLEAN));
    historySchema.AddColumn(NYT::TColumnSchema().Name(changedPrefix + F_TITLE).Type(NYT::VT_BOOLEAN));
    historySchema.AddColumn(NYT::TColumnSchema().Name(changedPrefix + F_DESCRIPTION).Type(NYT::VT_BOOLEAN));
    historySchema.AddColumn(NYT::TColumnSchema().Name(changedPrefix + F_REL_CANONICAL).Type(NYT::VT_BOOLEAN));
    // historySchema.AddColumn(NYT::TColumnSchema().Name("Debug").Type(NYT::VT_ANY));
    return historySchema;
}

inline NYT::TTableSchema CreateChangesSchema() {
    NYT::TTableSchema changesSchema;
    changesSchema.AddColumn(F_US_HOST_ID, NYT::VT_STRING);
    changesSchema.AddColumn(F_US_USER_ID, NYT::VT_UINT64);
    changesSchema.AddColumn(F_US_NOTIFICATION_TYPE, NYT::VT_STRING);
    changesSchema.AddColumn(F_US_EMAIL, NYT::VT_STRING);
    changesSchema.AddColumn(F_US_LOGIN, NYT::VT_STRING);
    changesSchema.AddColumn(F_US_FIO, NYT::VT_STRING);
    changesSchema.AddColumn(F_US_LANGUAGE, NYT::VT_STRING);
    changesSchema.AddColumn(F_US_CHANNEL_EMAIL, NYT::VT_BOOLEAN);
    changesSchema.AddColumn(F_US_CHANNEL_SERVICE, NYT::VT_BOOLEAN);
    changesSchema.AddColumn(F_US_CHANNEL_SUP, NYT::VT_BOOLEAN);
    changesSchema.AddColumn(F_CHANGES, NYT::VT_ANY);
    return changesSchema;
}

inline NYT::TTableSchema CreateUserSettingsSchema() {
    NYT::TTableSchema userSettingsSchema;
    userSettingsSchema.Strict(true);
    userSettingsSchema.AddColumn(NYT::TColumnSchema().Name(F_HOST).Type(NYT::VT_STRING));
    userSettingsSchema.AddColumn(NYT::TColumnSchema().Name(F_PATH).Type(NYT::VT_STRING));
    userSettingsSchema.AddColumn(NYT::TColumnSchema().Name(F_TABLE_TIMESTAMP).Type(NYT::VT_UINT64));
    userSettingsSchema.AddColumn(NYT::TColumnSchema().Name(F_USER_SETTINGS).Type(NYT::VT_ANY));
    return userSettingsSchema;
}

} //namespace NImportantUrls
} //namespace NWebmaster
