#pragma once

#include <util/generic/set.h>
#include <library/cpp/string_utils/url/url.h>
#include <mapreduce/yt/interface/client.h>
#include <wmconsole/version3/library/jupiter/search_url_status.h>
#include <wmconsole/version3/processors/indexing/important_urls/conf/config.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {
namespace NImportantUrls {

struct TImportantUrlsConfig {
    enum ETableType {
        E_TABLE_UNKNOWN = -1,
        E_TABLE_IMPORTANT_URLS,
        E_TABLE_SNAPSHOT,
        E_TABLE_JUPITER_BASE,
        E_TABLE_SPREAD_EXPORT,
        E_TABLE_CALLISTO_BASE,
        E_TABLE_CONTENT_ATTRS,
        E_TABLE_FAST_BAN,
        E_TABLE_TURBO_PAGE,
    };

public:
    TImportantUrlsConfig() = default;
    TImportantUrlsConfig(ETableType type, time_t timestamp = 0)
        : Type(type)
        , Timestamp(timestamp)
    {
    }

public:
    ETableType Type = E_TABLE_UNKNOWN;
    time_t Timestamp = 0;

    Y_SAVELOAD_DEFINE(Type, Timestamp)
};

int TaskUpdate(int, const char **);

} //namespace NImportantUrls
} //namespace NWebmaster
