#include <util/stream/file.h>
#include <util/string/subst.h>

#include "matcher_url.h"

Pire::Scanner TScanner::Compile(const char* pattern) { // https://wiki.yandex-team.ru/users/dprokoptsev/pire/doc
    std::vector<wchar32> ucs4;
    Pire::Encodings::Utf8().FromLocal(pattern, pattern + strlen(pattern), std::back_inserter(ucs4));
    return Pire::Lexer(ucs4.begin(), ucs4.end())
        .SetEncoding(Pire::Encodings::Utf8())
        .Parse()
        .Surround() //      PCRE_ANCHORED
        .Compile<Pire::Scanner>();
}

TString TScanner::Prepare(const TString &regexp) {
    TString res;
    res.reserve(regexp.size());
    res = "^";

    for (size_t i = 0; i < regexp.size(); i++) {
        if (regexp[i] == '\\' && i < regexp.size() - 1 && regexp[i + 1] == '*') {
            res.append("\\*");
            i++;
            continue;
        }

        switch(regexp[i]) {
            case '*':
                res.append(".*");
                break;
            //case '\'':
            case '\\':
            case '^':
            case '$':
            //case '&':
            case '+':
            case '?':
            case '.':
            case '(':
            case ')':
            case '|':
            case '{':
            case '}':
            case '[':
            case ']':
                res.append(1, '\\');
            default:
                res.append(1, regexp[i]);
        }
    }

    return res;
}

TScanner::TScanner(const TVector<TString> &filters) {
    TVector<TString>::const_iterator it = filters.begin();

    if (!filters.empty()) {
        Scanner = Compile(Prepare(filters.front()).data());
        ++it; //skip first element;
    }

    for (; it != filters.end(); ++it) {
        Scanner = Pire::Scanner::Glue(Scanner, Compile(Prepare(*it).data()));
    }
}

TMatcher::TMatcher(const TVector<TString> &filters)
    : Filters(filters)
{
}

bool TMatcher::Matches(const char* ptr, size_t len) {
    if (ScannerPtr.Get() == nullptr) {
        ScannerPtr.Reset(new TScanner(Filters));
    }

    Pire::Scanner::State state = Pire::Runner(ScannerPtr->Scanner)
        .Begin()                    //  
        .Run(ptr, len)              // 
        .End()                      //  
        .State();

    Accepted = ScannerPtr->Scanner.AcceptedRegexps(state);

    return Accepted.first != Accepted.second;
}

bool TMatcher::Matches(const TString &data) {
    return Matches(data.data(), data.size());
}
