#pragma once

#include <util/generic/ptr.h>
#include <util/generic/string.h>
#include <library/cpp/regex/pire/regexp.h>

struct TScanner {
    typedef TAtomicSharedPtr<TScanner> Ptr;

public:
    TScanner(const TVector<TString> &partitions);
    Pire::Scanner Compile(const char* pattern);
    TString Prepare(const TString &regexp);

public:
    Pire::Scanner Scanner;
};

struct TMatcher {
    typedef TAtomicSharedPtr<TMatcher> Ptr;

    TMatcher(const TVector<TString> &filters);
    bool Matches(const char* ptr, size_t len);
    bool Matches(const TString &data);

public:
    TVector<TString> Filters;

    TScanner::Ptr ScannerPtr;

    std::pair<const size_t*, const size_t*> Accepted;
};
