#include <library/cpp/testing/unittest/registar.h>

#include <yweb/robot/wmtree/treebuilder.h>
#include <yweb/robot/wmtree/treesaver.h>

#include "sitetree.h"

Y_UNIT_TEST_SUITE(TSiteTreeMRTest3) {
    Y_UNIT_TEST(SiteTreeBuilderTest) {
        using namespace NWebmaster;

        size_t DefaultSliceSize = 1000;
        size_t DefaultCompressFactor = 100;
        size_t DefaultMinNumOfUrlsInGroup = 10;

        typename TSiteTreeBuilder::TTreeBuilder builder(DefaultSliceSize, DefaultCompressFactor, DefaultMinNumOfUrlsInGroup, false, TSiteTreeBuilder::UrlSegmentParser);

        TTreeData data;
        data.NumOfDocs = 1;

        builder.AddUrl("/", data);
        builder.AddUrl("/dr/kater/foto/motor-neptun.jpg", data);
        builder.AddUrl("/dr/labirint/labirint_1.jpg", data);
        builder.AddUrl("/dr/labirint/labirint_2.jpg", data);
        builder.AddUrl("/dr/moloko/foto.mail.ru/inbox/2dim/_myphoto", data);
        builder.AddUrl("/dr/moloko/foto.mail.ru/inbox/2dim/_myphoto/", data);
        builder.AddUrl("/dr/moloko/prizolov.html", data);
        builder.AddUrl("/dr/podarok/kontent/dobro-pozhalovat-na-sajt-100-podarkov-ru/default.htm", data);
        builder.AddUrl("/dr/podarok/kontent/kak-sdelat-stilnyj-klatch-iz-knigi/default.htm", data);
        builder.AddUrl("/dr/podarok/wpc/gallery/1/1-5.jpg", data);
        builder.AddUrl("/dr/podarok/wpc/gallery/1/thumbs/thumbs_1-2.jpg", data);
        builder.AddUrl("/dr/podarok/wpc/gallery/2/2-m.jpg", data);
        builder.AddUrl("/dr/podarok/wpc/gallery/3/3-m.jpg", data);
        builder.AddUrl("/dr/podarok/wpc/gallery/6/6-2.jpg", data);
        builder.AddUrl("/dr/podarok/wpc/gallery/6/thumbs/thumbs_6-4.jpg", data);
        builder.AddUrl("/dr/podarok/wpc/gallery/7/thumbs/thumbs_7-m.jpg", data);
        builder.AddUrl("/dr/podarok/wpc/gallery/8/8-m.jpg", data);
        builder.AddUrl("/dr/stanok/1%20(3).JPG", data);
        builder.AddUrl("/favicon.ico", data);
        builder.AddUrl("/flashki/chapaev/shuffle.swf", data);
        builder.AddUrl("/flashki/himija/img/himija.jpg", data);
        builder.AddUrl("/flashki/homjaki/homjaki.html", data);
        builder.AddUrl("/flashki/homjaki/homjak.swf", data);
        builder.AddUrl("/flashki/zvezdi/zvezda.html", data);
        builder.AddUrl("/fotogalereja/dubki_2010_apr/images/thumbnail/sestroreck_dubki_2010_apr%20(16).JPG", data);
        builder.AddUrl("/fotogalereja/dubki_2010_apr/images/thumbnail/sestroreck_dubki_2010_apr%20(19).JPG", data);
        builder.AddUrl("/fotogalereja/dubki_2010_apr/images/thumbnail/sestroreck_dubki_2010_apr%20(21).JPG", data);
        builder.AddUrl("/fotogalereja/dubki_2010_apr/images/thumbnail/sestroreck_dubki_2010_apr%20(22).JPG", data);
        builder.AddUrl("/fotogalereja/dubki_2010_apr/images/thumbnail/sestroreck_dubki_2010_apr%20(26).JPG", data);
        builder.AddUrl("/fotogalereja/dubki_2010_apr/images/thumbnail/sestroreck_dubki_2010_apr%20(35).JPG", data);
        builder.AddUrl("/fotogalereja/dubki_2010_apr/images/thumbnail/sestroreck_dubki_2010_apr%20(36).JPG", data);
        builder.AddUrl("/fotogalereja/dubki_2010_apr/images/thumbnail/sestroreck_dubki_2010_apr%20(47).JPG", data);
        builder.AddUrl("/fotogalereja/dubki_2010_apr/images/thumbnail/sestroreck_dubki_2010_apr%20(49).JPG", data);
        builder.AddUrl("/fotogalereja/dubki_2010_apr/images/thumbnail/sestroreck_dubki_2010_apr%20(51).JPG", data);
        builder.AddUrl("/fotogalereja/dubki_2010_apr/images/thumbnail/sestroreck_dubki_2010_apr%20(69).JPG", data);
        builder.AddUrl("/fotogalereja/dubki_2010_apr/images/thumbnail/sestroreck_dubki_2010_apr%20(6).JPG", data);
        builder.AddUrl("/fotogalereja/dubki_2010_apr/images/thumbnail/sestroreck_dubki_2010_apr%20(76).JPG", data);
        builder.AddUrl("/fotogalereja/dubki_2010_apr/images/thumbnail/sestroreck_dubki_2010_apr%20(7).JPG", data);
        builder.AddUrl("/fotogalereja/dubki_2010_apr/pages/imagepage42.html", data);
        builder.AddUrl("/fotogalereja/dubki_2010_apr/pages/imagepage52.html", data);
        builder.AddUrl("/fotogalereja/kot/index.html", data);
        builder.AddUrl("/fotogalereja/zima_2010/images/fullsize/zima_priroda-2010-90.JPG.JPG", data);
        builder.AddUrl("/fotogalereja/zima_2010/images/thumbnail/zima_priroda-2010-12.JPG", data);
        builder.AddUrl("/fotogalereja/zima_2010/images/thumbnail/zima_priroda-2010-13.JPG", data);
        builder.AddUrl("/fotogalereja/zima_2010/images/thumbnail/zima_priroda-2010-30.JPG", data);
        builder.AddUrl("/fotogalereja/zima_2010/images/thumbnail/zima_priroda-2010-32.JPG", data);
        builder.AddUrl("/fotogalereja/zima_2010/images/thumbnail/zima_priroda-2010-36.JPG", data);
        builder.AddUrl("/fotogalereja/zima_2010/images/thumbnail/zima_priroda-2010-45.JPG", data);
        builder.AddUrl("/fotogalereja/zima_2010/images/thumbnail/zima_priroda-2010-49.JPG", data);
        builder.AddUrl("/fotogalereja/zima_2010/images/thumbnail/zima_priroda-2010-54.JPG", data);
        builder.AddUrl("/fotogalereja/zima_2010/images/thumbnail/zima_priroda-2010-61.JPG", data);
        builder.AddUrl("/fotogalereja/zima_2010/images/thumbnail/zima_priroda-2010-62.JPG", data);
        builder.AddUrl("/fotogalereja/zima_2010/images/thumbnail/zima_priroda-2010-64.JPG", data);
        builder.AddUrl("/fotogalereja/zima_2010/images/thumbnail/zima_priroda-2010-73.JPG", data);
        builder.AddUrl("/fotogalereja/zima_2010/images/thumbnail/zima_priroda-2010-76.JPG", data);
        builder.AddUrl("/fotogalereja/zima_2010/images/thumbnail/zima_priroda-2010-90.JPG", data);
        builder.AddUrl("/fotogalereja/zima_2010/images/thumbnail/zima_priroda-2010-95.JPG", data);
        builder.AddUrl("/fotogalereja/zima_2010/pages/image/imagepage49.html", data);
        builder.AddUrl("/fotogalereja/zima_2010/pages/image/imagepage52.html", data);
        builder.AddUrl("/fotogalereja/zima_2010/pages/image/imagepage53.html", data);
        builder.AddUrl("/fotogalereja/zima_2010/pages/image/imagepage8.html", data);
        builder.AddUrl("/img/favicon.ico", data);
        builder.AddUrl("/interesno/18/girljnda.html", data);
        builder.AddUrl("/interesno/21/dvd.html", data);
        builder.AddUrl("/interesno/21/robot-kolibri.html", data);
        builder.AddUrl("/interesno/drevn/nognici.html", data);
        builder.AddUrl("/interesno/drevn/ogon.html", data);
        builder.AddUrl("/klass/3b_556_shkola.html", data);
        builder.AddUrl("/old_site/index.files/image10341.jpg", data);
        builder.AddUrl("/old_site/index.files/image307.gif", data);
        builder.AddUrl("/old_site/index.files/image308.gif", data);
        builder.AddUrl("/old_site/index.files/image4281.jpg", data);
        builder.AddUrl("/old_site/index.files/image549.gif", data);
        builder.AddUrl("/old_site/index.files/image5511.jpg", data);
        builder.AddUrl("/podelki/foto/180-135/skorpion.JPG", data);
        builder.AddUrl("/podelki/foto/original/skorpion.jpg", data);
        builder.AddUrl("/podelki/juravlik.html", data);
        builder.AddUrl("/podelki/panda.html", data);
        builder.AddUrl("/podelki/raskidai.html", data);
        builder.AddUrl("/pozdravlju/foto/original/14_02_2008_mame-2.jpg", data);
        builder.AddUrl("/risunki/foto/180-135/rjabina_risunok.jpg", data);
        builder.AddUrl("/risunki/foto/600/cveti_risunok.jpg", data);
        builder.AddUrl("/risunki/foto/600/cvetnaja_zima_risunok.jpg", data);
        builder.AddUrl("/risunki/foto/600/oduvanchik_risunok.jpg", data);
        builder.AddUrl("/risunki/foto/600/zajac_risunok.jpg", data);
        builder.AddUrl("/risunki/foto/original/cvetnaja_zima_risunok.jpg", data);
        builder.AddUrl("/risunki/foto/original/mashina_risunok.jpg", data);
        builder.AddUrl("/risunki/foto/original/oduvanchik_risunok.jpg", data);
        builder.AddUrl("/risunki/foto/original/zajac_risunok.jpg", data);
        builder.AddUrl("/risunki/jabloki.html", data);
        builder.AddUrl("/seo/avto.html", data);
        builder.AddUrl("/seo/dom.html", data);
        builder.AddUrl("/sochinenija/kurenie.html", data);
        builder.AddUrl("/sochinenija/shkola.html", data);
        builder.AddUrl("/top/podelki.html", data);
        builder.CompleteBuild();

//        for (int i = 0; i < 10; i++) {
//            builder.AddUrl("/?aristotle/#page=navigation&path=//home/webmaster-test/sitetree/transmitted-1430902801&mode=content&offset=0&pageSize=50", data);
//        }

        TSet<TString> controlSet;

        controlSet.insert("1 0 /");
        controlSet.insert("2 1 /risunki");
        controlSet.insert("3 1 /dr");
        controlSet.insert("4 1 /fotogalereja");
        controlSet.insert("5 3 /podarok");
        controlSet.insert("6 4 /zima_2010");
        controlSet.insert("7 4 /dubki_2010_apr");
        controlSet.insert("8 6 /images");
        controlSet.insert("9 8 /thumbnail");
        controlSet.insert("10 7 /images");
        controlSet.insert("11 10 /thumbnail");

        TVector<TTreeRecord> siteStructure;

        TSiteTreeBuilder::TTreeRecordWriter writer(siteStructure);
        TTreeSaver<TSiteTreeBuilder::TBuilderNode, TSiteTreeBuilder::TTreeRecordWriter> saver(writer);
        saver.Save(builder.GetRoot().Get());

        for (TTreeRecord &record : siteStructure) {
            TStringStream str;
            str << record.NodeId << " " << record.ParentId << " " << record.Name;
            controlSet.erase(str.Str());
        }

        UNIT_ASSERT_EQUAL(controlSet.empty(), true);

        controlSet.insert("/");
        controlSet.insert("/risunki");
        controlSet.insert("/dr");
        controlSet.insert("/dr/podarok");
        controlSet.insert("/fotogalereja");
        controlSet.insert("/fotogalereja/zima_2010");
        controlSet.insert("/fotogalereja/zima_2010/images");
        controlSet.insert("/fotogalereja/zima_2010/images/thumbnail");
        controlSet.insert("/fotogalereja/dubki_2010_apr");
        controlSet.insert("/fotogalereja/dubki_2010_apr/images");
        controlSet.insert("/fotogalereja/dubki_2010_apr/images/thumbnail");

        TSiteTree siteTree(siteStructure, TUserPatternMatcher::Ptr());

        for (const auto &obj : siteTree.Shards) {
            for (const auto &obj2 : obj.second->TreePaths) {
                controlSet.erase(obj2.Path);
            }

            break;
        }

        UNIT_ASSERT_EQUAL(controlSet.empty(), true);
    }
}
