#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/vector.h>
#include "sitetree.h"

Y_UNIT_TEST_SUITE(TSiteTreeMRTest2) {
    Y_UNIT_TEST(SiteTreeExpanderTest) {
        using namespace NWebmaster;

        TVector<TTreeRecord> siteStructure;
        THolder<TSiteTree> siteTree;

        siteStructure.push_back(TTreeRecord("/", TTreeData(), 1, 0));
        siteStructure.push_back(TTreeRecord("/moto", TTreeData(), 2, 1));
        siteStructure.push_back(TTreeRecord("/car_accessories", TTreeData(), 3, 1));
        siteStructure.push_back(TTreeRecord("/batteries", TTreeData(), 4, 1));
        siteStructure.push_back(TTreeRecord("/acoustics", TTreeData(), 5, 1));
        siteStructure.push_back(TTreeRecord("/external_tuning", TTreeData(), 6, 1));
        siteStructure.push_back(TTreeRecord("/autohim", TTreeData(), 7, 1));
        siteStructure.push_back(TTreeRecord("/security", TTreeData(), 8, 1));
        siteStructure.push_back(TTreeRecord("/part", TTreeData(), 9, 1));
        siteStructure.push_back(TTreeRecord("/sneakers", TTreeData(), 10, 1));
        siteStructure.push_back(TTreeRecord("/electronics", TTreeData(), 11, 1));
        siteStructure.push_back(TTreeRecord("/disks", TTreeData(), 12, 1));
        siteStructure.push_back(TTreeRecord("/rug", TTreeData(), 13, 3));
        siteStructure.push_back(TTreeRecord("/carwash", TTreeData(), 14, 3));
        siteStructure.push_back(TTreeRecord("/model", TTreeData(), 15, 13));
        siteStructure.push_back(TTreeRecord("/model", TTreeData(), 16, 14));
        siteStructure.push_back(TTreeRecord("/accumulator", TTreeData(), 17, 4));
        siteStructure.push_back(TTreeRecord("/pre_chargers", TTreeData(), 18, 4));
        siteStructure.push_back(TTreeRecord("/model", TTreeData(), 19, 17));
        siteStructure.push_back(TTreeRecord("/model", TTreeData(), 20, 18));
        siteStructure.push_back(TTreeRecord("/interface", TTreeData(), 21, 5));
        siteStructure.push_back(TTreeRecord("/autorecorder", TTreeData(), 22, 5));
        siteStructure.push_back(TTreeRecord("/amplifiers", TTreeData(), 23, 5));
        siteStructure.push_back(TTreeRecord("/acoustics", TTreeData(), 24, 5));
        siteStructure.push_back(TTreeRecord("/model", TTreeData(), 25, 21));
        siteStructure.push_back(TTreeRecord("/model", TTreeData(), 26, 22));
        siteStructure.push_back(TTreeRecord("/model", TTreeData(), 27, 23));
        siteStructure.push_back(TTreeRecord("/model", TTreeData(), 28, 24));
        siteStructure.push_back(TTreeRecord("/deflector", TTreeData(), 29, 6));
        siteStructure.push_back(TTreeRecord("/arc", TTreeData(), 30, 6));
        siteStructure.push_back(TTreeRecord("/model", TTreeData(), 31, 29));
        siteStructure.push_back(TTreeRecord("/model", TTreeData(), 32, 30));
        siteStructure.push_back(TTreeRecord("/oil", TTreeData(), 33, 7));
        siteStructure.push_back(TTreeRecord("/model", TTreeData(), 34, 33));
        siteStructure.push_back(TTreeRecord("/alarm", TTreeData(), 35, 8));
        siteStructure.push_back(TTreeRecord("/model", TTreeData(), 36, 35));
        siteStructure.push_back(TTreeRecord("/model", TTreeData(), 37, 10));
        siteStructure.push_back(TTreeRecord("/kamera_zadnego_vida", TTreeData(), 38, 11));
        siteStructure.push_back(TTreeRecord("/parking", TTreeData(), 39, 11));
        siteStructure.push_back(TTreeRecord("/camcorder", TTreeData(), 40, 11));
        siteStructure.push_back(TTreeRecord("/radar", TTreeData(), 41, 11));
        siteStructure.push_back(TTreeRecord("/model", TTreeData(), 42, 38));
        siteStructure.push_back(TTreeRecord("/model", TTreeData(), 43, 39));
        siteStructure.push_back(TTreeRecord("/model", TTreeData(), 44, 40));
        siteStructure.push_back(TTreeRecord("/model", TTreeData(), 45, 41));
        siteStructure.push_back(TTreeRecord("/tag", TTreeData(), 46, 12));
        siteStructure.push_back(TTreeRecord("/model", TTreeData(), 47, 12));

        siteTree.Reset(new TSiteTree(siteStructure, TUserPatternMatcher::Ptr()));

        TSet<TString> controlPaths;
        controlPaths.insert("/");
        controlPaths.insert("/moto");
        controlPaths.insert("/car_accessories");
        controlPaths.insert("/car_accessories/rug");
        controlPaths.insert("/car_accessories/rug/model");
        controlPaths.insert("/car_accessories/carwash");
        controlPaths.insert("/car_accessories/carwash/model");
        controlPaths.insert("/batteries");
        controlPaths.insert("/batteries/accumulator");
        controlPaths.insert("/batteries/accumulator/model");
        controlPaths.insert("/batteries/pre_chargers");
        controlPaths.insert("/batteries/pre_chargers/model");
        controlPaths.insert("/acoustics");
        controlPaths.insert("/acoustics/interface");
        controlPaths.insert("/acoustics/interface/model");
        controlPaths.insert("/acoustics/autorecorder");
        controlPaths.insert("/acoustics/autorecorder/model");
        controlPaths.insert("/acoustics/amplifiers");
        controlPaths.insert("/acoustics/amplifiers/model");
        controlPaths.insert("/acoustics/acoustics");
        controlPaths.insert("/acoustics/acoustics/model");
        controlPaths.insert("/external_tuning");
        controlPaths.insert("/external_tuning/deflector");
        controlPaths.insert("/external_tuning/deflector/model");
        controlPaths.insert("/external_tuning/arc");
        controlPaths.insert("/external_tuning/arc/model");
        controlPaths.insert("/autohim");
        controlPaths.insert("/autohim/oil");
        controlPaths.insert("/autohim/oil/model");
        controlPaths.insert("/security");
        controlPaths.insert("/security/alarm");
        controlPaths.insert("/security/alarm/model");
        controlPaths.insert("/part");
        controlPaths.insert("/sneakers");
        controlPaths.insert("/sneakers/model");
        controlPaths.insert("/electronics");
        controlPaths.insert("/electronics/kamera_zadnego_vida");
        controlPaths.insert("/electronics/kamera_zadnego_vida/model");
        controlPaths.insert("/electronics/parking");
        controlPaths.insert("/electronics/parking/model");
        controlPaths.insert("/electronics/camcorder");
        controlPaths.insert("/electronics/camcorder/model");
        controlPaths.insert("/electronics/radar");
        controlPaths.insert("/electronics/radar/model");
        controlPaths.insert("/disks");
        controlPaths.insert("/disks/tag");
        controlPaths.insert("/disks/model");

        for (const auto &obj : siteTree->Shards) {
            for (const auto &obj2 : obj.second->TreePaths) {
                UNIT_ASSERT_UNEQUAL(controlPaths.find(obj2.Path), controlPaths.end());
            }

            UNIT_ASSERT_EQUAL(obj.second->TreePaths.size(), controlPaths.size());
        }

        TSet<TString> controlRecords;
        controlRecords.insert("0 0 1 /");
        controlRecords.insert("0 0 4 /batteries");
        controlRecords.insert("0 0 17 /accumulator");
        controlRecords.insert("0 0 19 /model");

        controlRecords.insert("1 4 1 /");
        controlRecords.insert("1 4 4 /batteries");
        controlRecords.insert("1 4 17 /accumulator");
        controlRecords.insert("1 4 19 /model");

        for (const auto &obj : siteTree->Shards) {
            TString path = "/batteries/accumulator/model/";

            typedef TPrefixIterator<TCompactTrie<char>> TPrefixIterator;
            TPrefixIterator it = MakePrefixIterator(obj.second->Trie, path.data(), path.size());

            UNIT_ASSERT_EQUAL(!!it, true);

            while (it) {
                size_t filterNo;
                it.GetValue(filterNo);
                int matchedNodeId = obj.second->TreePaths[filterNo].NodeId;
                TWrapperNode::Ptr &node = obj.second->IdNodeMap[matchedNodeId];

                TStringStream ss;
                ss << ToString((int)obj.first.first) << " " << ToString((int)obj.first.second) << " " << ToString(matchedNodeId) << " " << node->Name;
                controlRecords.erase(ss.Str());
                ++it;
            }
        }

        UNIT_ASSERT_EQUAL(controlRecords.empty(), true);
    }
}
