#pragma once

#include <util/generic/singleton.h>
#include <util/generic/string.h>
#include <util/string/subst.h>

#include <wmconsole/version3/library/conf/yt.h>

#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {
namespace NRobotsTxt {

struct TConfig {
    static TConfig &Instance() {
        return *Singleton<TConfig>();
    }

    static const TConfig &CInstance() {
        return Instance();
    }

    TConfig() {
        const auto &ccfg = TCommonYTConfig::CInstance();

        MR_SERVER_HOST                              = "arnold.yt.yandex.net";
        MR_SERVER_HOST_KWYT                         = "arnold.yt.yandex.net";

        TABLE_SOURCE_ROBOTS                         = "//home/kwyt/hosts/robots";

        TABLE_SOURCE_WEBMASTER_HOSTS                = ccfg.TABLE_SOURCE_WEBMASTER_HOSTS;
        TABLE_SOURCE_WEBMASTER_HOSTS_ROW_COUNT      = 4000000;

        TABLE_ROBOTS_ROOT                           = NYTUtils::JoinPath(ccfg.TABLE_ROOT, "kwyt", "robots");
        TABLE_ROBOTS_HOSTS_WEBMASTER                = NYTUtils::JoinPath(TABLE_ROBOTS_ROOT, "hosts-webmaster");
        TABLE_ROBOTS_HOSTS_EXTERNAL                 = NYTUtils::JoinPath(TABLE_ROBOTS_ROOT, "hosts-external");
        TABLE_ROBOTS_HOSTS                          = NYTUtils::JoinPath(TABLE_ROBOTS_ROOT, "hosts");

        TABLE_EXPORT_ROBOTS                         = NYTUtils::JoinPath(ccfg.GetStagePath(ccfg.TABLE_EXPORT_ROOT), "robots_txt_v2");
    }

public:
    TString MR_SERVER_HOST;
    TString MR_SERVER_HOST_KWYT;

    TString TABLE_SOURCE_WEBMASTER_HOSTS;
    size_t TABLE_SOURCE_WEBMASTER_HOSTS_ROW_COUNT;
    TString TABLE_SOURCE_ROBOTS;

    TString TABLE_ROBOTS_ROOT;
    TString TABLE_ROBOTS_HOSTS;
    TString TABLE_ROBOTS_HOSTS_EXTERNAL;
    TString TABLE_ROBOTS_HOSTS_WEBMASTER;

    TString TABLE_EXPORT_ROBOTS;
};

} //namespace NRobotsTxt
} //namespace NWebmaster
